#!/usr/bin/env python
#
# Copyright 2009 Canonical, Ltd
# Author: Brian Murray <brian@ubuntu.com>
# License: GPLv3
# 
# 2009-12-10 
# search for duplicate bugs of an Ubuntu bug task using
# launchpadlib's findSimilarBugs()

from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT, STAGING_SERVICE_ROOT
from launchpadlib.errors import HTTPError
from launchpadlib.credentials import Credentials

import os, sys, re

cachedir = os.path.expanduser("~/.launchpadlib/cache/")

if not os.path.exists(cachedir):
    os.makedirs(cachedir,0700)

script_name = sys.argv[0].split("/")[-1].split('.')[0]

credfile = os.path.expanduser('~/.launchpadlib/%s.cred' % script_name)

try:
    credentials = Credentials()
    credentials.load(open(credfile))
    launchpad = Launchpad(credentials, EDGE_SERVICE_ROOT, cachedir)
except:
    launchpad = Launchpad.get_token_and_login(script_name, EDGE_SERVICE_ROOT, cachedir)
    launchpad.credentials.save(open(credfile,"w",0600)) 
    
target = sys.argv[1]

bug = launchpad.bugs[target]

for task in bug.bug_tasks:
    # this avoids checking upstream and release tasks
    if '(Ubuntu)' in task.bug_target_name:
        bug_numbers = []
        print "Similar bugs about package %s:" % task.bug_target_name
        similar = task.findSimilarBugs()
        for bug in similar:
            bug_numbers.append(bug.id)
        bug_numbers.sort(reverse=True)
        for number in bug_numbers:
            print "\tLP: #%s" % number
