#!/usr/bin/python

from distutils.core import setup
import glob
import os
import re

# look/set what version we have
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)

setup(name='ubuntu-qa-tools',
      version=version,
      scripts=['bug-parsers/check-needs-packaging',
               'bugs-mailinglist/body-searching',
               'bugs-mailinglist/count-senders',
               'bugs-mailinglist/tagged-bugs',
               'bugs-mailinglist/triager-query',
               'bugs-mailinglist/ml-team-fixes-report.py',
               'bugs-mailinglist/ml-fixes-report.py',
               'bugs-mailinglist/new-bug-description-search',
               'bugtrackers/debian-bug-search',
               'dl-ubuntu-test-iso/dl-ubuntu-test-iso',
               'dl-ubuntu-test-iso/iso-ripper',
               'hugday-tools/hugday',
            ],
    packages=[],
)
