#!/bin/bash

DEV=${1:?Missing device name}
VIRTIP="10.1.200.50/27"

IPCMD=/sbin/ip
LOGGER=/usr/bin/logger

[ -x $LOGGER ] || exit 1

if [ ! -x $IPCMD ] ; then
    $LOGGER -i -t ucarp-vipup "ERROR: $IPCMD missing"
    exit 1
fi

$IPCMD addr add $VIRTUP dev $DEV

$LOGGER -i -t ucarp-vipup "Entering MASTER state for $VIRTIP"

RETVAL=$?

if [ $RETVAL != 0 ] ; then
    $LOGGER -i -t ucarp-vipup "Failed to init $VIRTIP, dev $DEV"
fi
