/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QSettings>
#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QPushButton>
#include <QCloseEvent>
#include <QTextEdit>
#include <QLineEdit>
#include <QComboBox>
#include <QTextCursor>
#include <mgl/mgl_parse.h>
#include "finddialog.h"
extern mglParse parser;
mglData mglFormulaCalc(const wchar_t *string, mglParse *arg);
//-----------------------------------------------------------------------------
FindDialog::FindDialog(QWidget *parent) : QDialog(parent)
{
	QLabel *lbl;
	QHBoxLayout *a;
	setWindowTitle(tr("UDAV - Find"));
	QVBoxLayout *o = new QVBoxLayout;
	a = new QHBoxLayout;	o->addLayout(a);
	lbl = new QLabel(tr("Find &what:"), this);			a->addWidget(lbl);
	line = new QLineEdit(this);	lbl->setBuddy(line);	a->addWidget(line);
	a = new QHBoxLayout;	o->addLayout(a);
	lbl = new QLabel(tr("Replace &by:"), this);			a->addWidget(lbl);
	text = new QLineEdit(this);	lbl->setBuddy(text);	a->addWidget(text);

	caseUse = new QCheckBox(tr("Match &case"), this);	o->addWidget(caseUse);
	backward = new QCheckBox(tr("Search &backward"), this);	o->addWidget(backward);

	a = new QHBoxLayout(this);	a->setMargin(11);
	a->setSpacing(6);			a->addLayout(o);
	o = new QVBoxLayout;		a->addLayout(o);
	find = new QPushButton(tr("&Find"), this);		o->addWidget(find);
	find->setDefault(true);	find->setEnabled(false);
	repl= new QPushButton(tr("&Replace"), this);	o->addWidget(repl);
	repl->setEnabled(false);
	cancel = new QPushButton(tr("Close"), this);	o->addWidget(cancel);
	o->addStretch(1);
	connect(line, SIGNAL(textChanged(const QString &)), this, SLOT(enableFind(const QString &)));
	connect(find, SIGNAL(clicked()), this, SLOT(findClicked()));
	connect(repl, SIGNAL(clicked()), this, SLOT(replClicked()));
	connect(cancel, SIGNAL(clicked()),this, SLOT(close()));
}
//-----------------------------------------------------------------------------
FindDialog::~FindDialog()	{}
//-----------------------------------------------------------------------------
void FindDialog::findClicked()
{	emit findText(line->text(), caseUse->isChecked(), backward->isChecked());	}
//-----------------------------------------------------------------------------
void FindDialog::replClicked()
{	emit replText(line->text(), text->text(), caseUse->isChecked(), backward->isChecked());	}
//-----------------------------------------------------------------------------
void FindDialog::enableFind(const QString &txt)
{	find->setEnabled(!txt.isEmpty());	repl->setEnabled(!txt.isEmpty());	}
//-----------------------------------------------------------------------------
void FindDialog::closeEvent(QCloseEvent *event)
{
	emit replText("", "", false, false);
	event->accept();
}
//-----------------------------------------------------------------------------
//
//	Hint dialog
//
//-----------------------------------------------------------------------------
#define qtr		HintDialog::tr
int numHints=-1;
QString hints[] = {
	qtr("You can rotate plot by mouse. Just press 'Rotate' toolbutton, click image and hold a mouse button: left button for rotation, right button for zooming/perspective, middle button for shifting."),
	qtr("You may quickly draw the data from file. Just use: udav 'filename.dat' in command line."),
	qtr("You can copy the current image to clipboard by pressing Ctrl-Shift-C. Later you can paste it directly into yours document or presentation."),
	qtr("You can export image into a set of format (EPS, SVG, PNG, JPEG) by pressing right mouse button inside image and selecting 'Export as ...'."),
	qtr("You can setup colors for script highlighting in Property dialog. Just select menu item 'Edit/Properties'."),
	qtr("You can save the parameter of animation inside MGL script by using comment started from '##a '."),
	qtr("New drawing never clears things drawn already. For example, you can make a surface with contour lines by calling commands 'surf' and 'cont' one after another (in any order). "),
	qtr("You can put several plots in the same image by help of commands 'subplot' or 'inplot'."),
	qtr("All indexes (of data arrays, subplots and so on) are always start from 0."),
	qtr("You can edit MGL file in any text editor. Also you can run it in console by help of commands: mgl2png, mgl2eps, mgl2svg and so on."),
	qtr("You can use command 'once on|off' for marking the block which should be executed only once. For example, this can be the block of large data reading/creating/handling. Press F9 (or menu item 'Graphics/Reload') to re-execute this block."),
	qtr("You can use command 'stop' for terminating script parsing. It is useful if you don't want to execute a part of script."),
	qtr("You can type arbitrary expression as input argument for data or number. In last case, the first value of data array is used."),
	qtr("There is powerful calculator with a lot of special functions. You can use buttons or keyboard to type the expression. Also you can use existed variables in the expression."),
	qtr("The calculator can help you to put complex expression in the script. Just type the expression (which may depend on coordinates x,y,z and so on) and put it into the script."),
	qtr("You can easely insert file or folder names, last fitted formula or numerical value of selection by using menu Edit|Insert."),
	qtr("The special dialog (Edit|Insert|New Command) help you select the command, fill its arguments and put it into the script."),
	qtr("")};

//-----------------------------------------------------------------------------
double mgl_rnd();
HintDialog::HintDialog(QWidget *parent) : QDialog(parent)
{
	if(numHints<0)
		for(numHints=0;!hints[numHints].isEmpty();numHints++){};
	cur = int(mgl_rnd()*numHints);
	setWindowTitle(tr("UDAV - Hint"));
	QHBoxLayout *a;
	QPushButton *b;
	QVBoxLayout *o = new QVBoxLayout(this);
	text = new QTextEdit(this);	o->addWidget(text);
	text->setReadOnly(true);	text->setText(hints[cur]);

	start = new QCheckBox(tr("&Show at startup"), this);	o->addWidget(start);
	start->setChecked(true);

	a = new QHBoxLayout;	o->addLayout(a);
	b = new QPushButton(tr("&Prev"), this);		a->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(prevClicked()));
	b = new QPushButton(tr("&Next"), this);		a->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(nextClicked()));
	b = new QPushButton(tr("&Close"), this);	a->addWidget(b);
	connect(b, SIGNAL(clicked()),this, SLOT(close()));
}
//-----------------------------------------------------------------------------
HintDialog::~HintDialog()	{}
//-----------------------------------------------------------------------------
void HintDialog::nextClicked()
{	cur = (cur+1)%numHints;	text->setText(hints[cur]);	}
//-----------------------------------------------------------------------------
void HintDialog::prevClicked()
{	cur--;	if(cur<0)	cur=numHints-1;	text->setText(hints[cur]);	}
//-----------------------------------------------------------------------------
void HintDialog::closeEvent(QCloseEvent *)
{
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	settings.setValue("/showHint", start->isChecked());
	settings.endGroup();
}
//-----------------------------------------------------------------------------
//
//	Calc dialog
//
//-----------------------------------------------------------------------------
CalcDialog::CalcDialog(QWidget *parent) : QWidget(parent)
{
	QPushButton *b;
	QHBoxLayout *m=new QHBoxLayout(this), *oo;
	QVBoxLayout *o=new QVBoxLayout;	m->addLayout(o);	m->setStretchFactor(o,1);

	text = new QTextEdit(this);	o->addWidget(text);
	connect(text,SIGNAL(textChanged()),this,SLOT(evaluate()));
	oo = new QHBoxLayout;		o->addLayout(oo);
	QLabel *l = new QLabel(tr("Result"),this);	oo->addWidget(l);
	result=new QLineEdit(this);	oo->addWidget(result);
	result->setReadOnly(true);
	b = new QPushButton(tr("To script"), this);	oo->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(keyPut()));
	b = new QPushButton(tr("Clear"), this);	oo->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(clear()));

	QGridLayout *g = new QGridLayout;	m->addLayout(g);	m->setStretchFactor(g,0);
	b = new QPushButton("7", this);	g->addWidget(b, 0, 0);
	int minw=b->height();	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key7()));
	b = new QPushButton("8", this);	g->addWidget(b, 0, 1);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key8()));
	b = new QPushButton("9", this);	g->addWidget(b, 0, 2);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key9()));
	b = new QPushButton("+", this);	g->addWidget(b, 0, 3);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(keyAdd()));
	b = new QPushButton(QString::fromWCharArray(L"π"), this);	g->addWidget(b, 0, 4);
	connect(b, SIGNAL(clicked()), this, SLOT(keyPi()));		b->setMaximumWidth(minw);

	b = new QPushButton("4", this);	g->addWidget(b, 1, 0);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key4()));
	b = new QPushButton("5", this);	g->addWidget(b, 1, 1);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key5()));
	b = new QPushButton("6", this);	g->addWidget(b, 1, 2);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key6()));
	b = new QPushButton("-", this);	g->addWidget(b, 1, 3);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(keySub()));
	b = new QPushButton(QString::fromWCharArray(L"x²"), this);	g->addWidget(b, 1, 4);
	connect(b, SIGNAL(clicked()), this, SLOT(keyX2()));		b->setMaximumWidth(minw);

	b = new QPushButton("1", this);	g->addWidget(b, 2, 0);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key1()));
	b = new QPushButton("2", this);	g->addWidget(b, 2, 1);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key2()));
	b = new QPushButton("3", this);	g->addWidget(b, 2, 2);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key3()));
	b = new QPushButton("*", this);	g->addWidget(b, 2, 3);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(keyMul()));
	b = new QPushButton("(", this);	g->addWidget(b, 2, 4);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(keyBrO()));

	b = new QPushButton("0", this);	g->addWidget(b, 3, 0);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(key0()));
	b = new QPushButton(".", this);	g->addWidget(b, 3, 1);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(keyDot()));
	b = new QPushButton("E", this);	g->addWidget(b, 3, 2);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(keyE()));
	b = new QPushButton("/", this);	g->addWidget(b, 3, 3);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(keyDiv()));
	b = new QPushButton(")", this);	g->addWidget(b, 3, 4);	b->setMaximumWidth(minw);
	connect(b, SIGNAL(clicked()), this, SLOT(keyBrC()));

	fillFuncName();
	o=new QVBoxLayout;	m->addLayout(o);	m->setStretchFactor(o,0);
	type = new QComboBox(this);		o->addWidget(type);
	type->addItems(names);	type->setCurrentIndex(0);
	func = new QComboBox(this);		o->addWidget(func);
	func->addItems(funcName[0]);	type->setCurrentIndex(0);
	descr= new QLabel(this);		o->addWidget(descr);	o->setStretchFactor(descr,0);
	descr->setText(funcInfo[0].at(0));
	connect(type, SIGNAL(currentIndexChanged(int)), this, SLOT(typeUpdate(int)));
	connect(func, SIGNAL(currentIndexChanged(int)), this, SLOT(funcUpdate(int)));
	b = new QPushButton(tr("Put function"), this);	o->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(keyFnc()));
}
//-----------------------------------------------------------------------------
CalcDialog::~CalcDialog()	{}
void CalcDialog::foc()	{	text->setFocus(Qt::ActiveWindowFocusReason);	}
//-----------------------------------------------------------------------------
void CalcDialog::key1()	{	text->textCursor().insertText("1");	foc();	}
void CalcDialog::key2()	{	text->textCursor().insertText("2");	foc();	}
void CalcDialog::key3()	{	text->textCursor().insertText("3");	foc();	}
void CalcDialog::key4()	{	text->textCursor().insertText("4");	foc();	}
void CalcDialog::key5()	{	text->textCursor().insertText("5");	foc();	}
void CalcDialog::key6()	{	text->textCursor().insertText("6");	foc();	}
void CalcDialog::key7()	{	text->textCursor().insertText("7");	foc();	}
void CalcDialog::key8()	{	text->textCursor().insertText("8");	foc();	}
void CalcDialog::key9()	{	text->textCursor().insertText("9");	foc();	}
void CalcDialog::key0()	{	text->textCursor().insertText("0");	foc();	}
void CalcDialog::keyE()	{	text->textCursor().insertText("E");	foc();	}
void CalcDialog::keyPi()	{	text->textCursor().insertText("pi");	foc();	}
void CalcDialog::keyX2()	{	text->textCursor().insertText("^2");	foc();	}
void CalcDialog::keyAdd()	{	text->textCursor().insertText("+");	foc();	}
void CalcDialog::keyMul()	{	text->textCursor().insertText("*");	foc();	}
void CalcDialog::keySub()	{	text->textCursor().insertText("-");	foc();	}
void CalcDialog::keyDiv()	{	text->textCursor().insertText("/");	foc();	}
void CalcDialog::keyBrO()	{	text->textCursor().insertText("(");	foc();	}
void CalcDialog::keyBrC()	{	text->textCursor().insertText(")");	foc();	}
void CalcDialog::keyDot()	{	text->textCursor().insertText(".");	foc();	}
void CalcDialog::clear()	{	text->clear();	foc();	}
//-----------------------------------------------------------------------------
void CalcDialog::keyFnc()
{
	text->textCursor().insertText(func->currentText());
	text->moveCursor(QTextCursor::PreviousCharacter);	foc();
}
//-----------------------------------------------------------------------------
void CalcDialog::keyPut()	{	emit putNumber(result->text());	}
//-----------------------------------------------------------------------------
void CalcDialog::evaluate()
{
	QString sel=text->toPlainText();
	if(sel.isEmpty())	return;
	wchar_t *txt=new wchar_t[sel.length()+1];
	sel.toWCharArray(txt);	txt[sel.length()]=0;
	setlocale(LC_ALL, "C");
	mglData res=mglFormulaCalc(txt, &parser);
	setlocale(LC_ALL, "");
//	result->setText(QString::fromWCharArray(txt));
	delete []txt;
	result->setText(QString::number(res.a[0]));
}
//-----------------------------------------------------------------------------
void CalcDialog::fillFuncName()
{
	names<<tr("Basic")<<tr("Exp and log")<<tr("Trigonometric")<<tr("Hyperbolic")
			<<tr("Bessel")<<tr("Elliptic")<<tr("Jacobi")<<tr("Airy and Gamma")
			<<tr("Exp-integrals")<<tr("Special");
	// basic
	funcName[0]<<"abs()"<<"sign()"<<"step()"<<"sqrt()"<<"mod(,)"<<"arg(,)";
	funcInfo[0]<<"Absolute value"<<"Sign of number"<<"Step function"
			<<"Square root"<<"x modulo y"<<"Argument of complex number";
	// exp and logarithms
	funcName[1]<<"exp()"<<"pow(,)"<<"ln()"<<"lg()"<<"log(,)";
	funcInfo[1]<<"Exponential function e^x"<<"Power x^y"<<"Logarithm of x"
			<<"Decimal logarithm of x"<<"Logarithm of x on base a";
	// trigonometric
	funcName[2]<<"sin()"<<"cos()"<<"tan()"<<"sinc()"<<"asin()"<<"acos()"<<"atan()";
	funcInfo[2]<<"Sine function"<<"Cosine function"<<"Tangent function"<<"sin(x)/x"
			<<"Inverse sine function"<<"Inverse cosine function"<<"Inverse tangent function";
	// hyperbolic
	funcName[3]<<"sinh()"<<"cosh()"<<"tanh()"<<"asinh()"<<"acosh()"<<"atanh()";
	funcInfo[3]<<"Hyperbolic sine function"<<"Hyperbolic cosine function"
			<<"Hyperbolic tangent function"<<"Inverse hyperbolic sine function"
			<<"Inverse hyperbolic cosine function"<<"Inverse hyperbolic tangent function";
	// bessel
	funcName[4]<<"bessel_j(,)"<<"bessel_y(,)"<<"bessel_i(,)"<<"bessel_k(,)";
	funcInfo[4]<<"Regular cylindrical Bessel function"<<"Irregular cylindrical Bessel function"
			<<"Regular modified Bessel function"<<"Irregular modified Bessel function";
	// elliptic
	funcName[5]<<"elliptic_e(,)"<<"elliptic_f(,)"<<"elliptic_ec()"<<"elliptic_kc()";
	funcInfo[5]<<"Elliptic integral E(phi,k)"<<"Elliptic integral F(phi,k)"
			<<"Complete elliptic integral E(k)"<<"Complete elliptic integral K(k)";
	// jacobi
	funcName[6]<<"sn(,)"<<"cn(,)"<<"dn(,)"<<"sc(,)"<<"dc(,)"<<"nc(,)"<<"cs(,)"
			<<"ds(,)"<<"ns(,)"<<"sd(,)"<<"cd(,)"<<"nd(,)";
	funcInfo[6]<<"Jacobi function sn(u|m)"<<"Jacobi function cn(u|m)"
			<<"Jacobi function dn(u|m)"<<"Jacobi function sn(u|m)/cn(u|m)"
			<<"Jacobi function dn(u|m)/cn(u|m)"<<"Jacobi function 1/cn(u|m)"
			<<"Jacobi function cn(u|m)/sn(u|m)"<<"Jacobi function dn(u|m)/sn(u|m)"
			<<"Jacobi function 1/sn(u|m)"<<"Jacobi function sn(u|m)/dn(u|m)"
			<<"Jacobi function cn(u|m)/dn(u|m)"<<"Jacobi function 1/dn(u|m)";
	// airy and gamma
	funcName[7]<<"airy_ai()"<<"airy_bi()"<<"airy_dai()"<<"airy_dbi()"<<"gamma()"<<"psi()"<<"beta(,)";
	funcInfo[7]<<"Airy function Ai(x)"<<"Airy function Bi(x)"
			<<"Derivative of Airy function Ai'(x)"<<"Derivative of Airy function Bi'(x)"
			<<QString::fromWCharArray(L"Gamma function Γ(x)")
			<<QString::fromWCharArray(L"Digamma function Γ'(x)/Γ(x)")
			<<QString::fromWCharArray(L"Beta function Γ(x)*Γ(y)/Γ(x+y)");
	// exp integrals
	funcName[8]<<"ci()"<<"si()"<<"ei()"<<"e1()"<<"e2()"<<"ei3()";
	funcInfo[8]<<QString::fromWCharArray(L"Cosine integral ∫dt cos(t)/t")
			<<QString::fromWCharArray(L"Sine integral ∫dt sin(t)/t")
			<<QString::fromWCharArray(L"Integral -∫dt exp(-t)/t")
			<<QString::fromWCharArray(L"Integral Re ∫dt exp(-xt)/t")
			<<QString::fromWCharArray(L"Integral Re∫dt exp(-xt)/t^2")
			<<QString::fromWCharArray(L"Integral ∫dt exp(-t^3)");
	// special
	funcName[9]<<"erf()"<<"z()"<<"legendre(,)"<<"dilog()"<<"eta()"<<"zeta()"<<"w0()"<<"w1()";
	funcInfo[9]<<QString::fromWCharArray(L"Error function 2/√π ∫dt exp(-t^2)")<<"Dawson function"
			<<"Legendre polynomial P_l(x)"<<QString::fromWCharArray(L"Dilogarithm -Re∫ds ln(1-s)/s")
			<<"Eta function (1-2/2^s)*zeta(s)"<<"Riemann zeta function"
			<<"Lambert W function W_0(x)"<<"Lambert W function W_{-1}(x)";
}
//-----------------------------------------------------------------------------
void CalcDialog::typeUpdate(int s)
{
	if(s<0 && s>9)	return;
	func->clear();	func->addItems(funcName[s]);	func->setCurrentIndex(0);
}
//-----------------------------------------------------------------------------
void CalcDialog::funcUpdate(int f)
{
	int s=type->currentIndex();
	if(s<0 || s>9 || f<0)	return;	// wrong index
	descr->setText(funcInfo[s].at(f));
}
//-----------------------------------------------------------------------------
