/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QPushButton>
#include <QMessageBox>
#include <QLineEdit>
#include <QComboBox>
#include <QLayout>
#include <QLabel>
#include <QRadioButton>
#include <mgl/mgl_parse.h>
#include "optiondialog.h"
int numDataOpened=0;
extern mglParse parser;
//-----------------------------------------------------------------------------
OptionDialog::OptionDialog(QWidget *parent) : QDialog(parent)
{
	setWindowTitle(tr("UDAV - Add options"));
	QHBoxLayout *a;
	QGridLayout *g;
	QLabel *lbl;
	QPushButton *b;
	QVBoxLayout *o = new QVBoxLayout(this);	//o->setSpacing(6);
	g = new QGridLayout();		o->addLayout(g);
	lbl = new QLabel(tr("X-range"),this);	g->addWidget(lbl,0,0);
	x1 = new QLineEdit(this);	g->addWidget(x1,0,1);
	x2 = new QLineEdit(this);	g->addWidget(x2,0,2);
	lbl = new QLabel(tr("Y-range"),this);	g->addWidget(lbl,0,3);
	y1 = new QLineEdit(this);	g->addWidget(y1,0,4);
	y2 = new QLineEdit(this);	g->addWidget(y2,0,5);
	lbl = new QLabel(tr("Z-range"),this);	g->addWidget(lbl,1,0);
	z1 = new QLineEdit(this);	g->addWidget(z1,1,1);
	z2 = new QLineEdit(this);	g->addWidget(z2,1,2);
	lbl = new QLabel(tr("C-range"),this);	g->addWidget(lbl,1,3);
	c1 = new QLineEdit(this);	g->addWidget(c1,1,4);
	c2 = new QLineEdit(this);	g->addWidget(c2,1,5);
	g = new QGridLayout();		o->addLayout(g);
	lbl = new QLabel(tr("Alpha"),this);		g->addWidget(lbl,0,0);
	alpha = new QLineEdit(this);	g->addWidget(alpha,1,0);
	lbl = new QLabel(tr("Ambient"),this);	g->addWidget(lbl,0,1);
	amb = new QLineEdit(this);		g->addWidget(amb,1,1);
	lbl = new QLabel(tr("Mesh num"),this);	g->addWidget(lbl,0,2);
	mn = new QLineEdit(this);		g->addWidget(mn,1,2);
	lbl = new QLabel(tr("Font size"),this);	g->addWidget(lbl,0,3);
	fs = new QLineEdit(this);		g->addWidget(fs,1,3);
	lbl = new QLabel(tr("Cutting"),this);	g->addWidget(lbl,0,4);
	cut = new QComboBox(this);		g->addWidget(cut,1,4);
	cut->insertItem(0,tr("on"));	cut->insertItem(1,tr("off"));
	a = new QHBoxLayout();	o->addLayout(a);
	lbl = new QLabel(tr("Legend"),this);	a->addWidget(lbl);
	leg = new QLineEdit(this);	a->addWidget(leg);
	a = new QHBoxLayout();	o->addLayout(a);
	a->addStretch(1);
	b = new QPushButton(tr("Cancel"), this);	a->addWidget(b);
	connect(b, SIGNAL(clicked()),this, SLOT(reject()));
	b = new QPushButton(tr("OK"), this);		a->addWidget(b);
	connect(b, SIGNAL(clicked()),this, SLOT(prepareResult()));
	b->setDefault(true);
}
//-----------------------------------------------------------------------------
OptionDialog::~OptionDialog()	{}
//-----------------------------------------------------------------------------
void OptionDialog::prepareResult()
{
	result = "";
	if(!x1->text().isEmpty() && !x2->text().isEmpty())
		result = result + "; xrange "+x1->text()+" "+x2->text();
	if((x1->text().isEmpty()) ^ (x2->text().isEmpty()))
	{
		QMessageBox::warning(this,tr("UDAV - command options"), tr("Both fields in xrange must be filled"));
		return;
	}
	if(!y1->text().isEmpty() && !y2->text().isEmpty())
		result = result + "; yrange "+y1->text()+" "+y2->text();
	if((y1->text().isEmpty()) ^ (y2->text().isEmpty()))
	{
		QMessageBox::warning(this,tr("UDAV - command options"), tr("Both fields in yrange must be filled"));
		return;
	}
	if(!z1->text().isEmpty() && !z2->text().isEmpty())
		result = result + "; zrange "+z1->text()+" "+z2->text();
	if((z1->text().isEmpty()) ^ (z2->text().isEmpty()))
	{
		QMessageBox::warning(this,tr("UDAV - command options"), tr("Both fields in zrange must be filled"));
		return;
	}
	if(!c1->text().isEmpty() && !c2->text().isEmpty())
		result = result + "; crange "+c1->text()+" "+c2->text();
	if((c1->text().isEmpty()) ^ (c2->text().isEmpty()))
	{
		QMessageBox::warning(this,tr("UDAV - command options"), tr("Both fields in crange must be filled"));
		return;
	}
	if(!alpha->text().isEmpty())	result = result+"; alpha "+alpha->text();
	if(!amb->text().isEmpty())	result = result+"; ambient "+amb->text();
	if(!mn->text().isEmpty())	result = result+"; meshnum "+mn->text();
	if(!fs->text().isEmpty())	result = result+"; fontsize "+fs->text();
	if(cut->currentIndex()==0)	result = result+"; cut on";
	if(cut->currentIndex()==1)	result = result+"; cut off";
	if(!leg->text().isEmpty())	result = result+"; legend '"+leg->text()+"'";
	accept();
}
//-----------------------------------------------------------------------------
DataOpenDialog::DataOpenDialog(QWidget *parent) : QDialog(parent)
{
	setWindowTitle(tr("UDAV - Open data file"));
	QHBoxLayout *a;
	QLabel *l;
	QPushButton *b;
	QVBoxLayout *o=new QVBoxLayout(this);

	a = new QHBoxLayout;	o->addLayout(a);
	l = new QLabel(tr("Data name"));	a->addWidget(l);
	char buf[32];	sprintf(buf,"mgl_%d",numDataOpened);
	name = new QLineEdit(buf,this);		a->addWidget(name);

	rA = new QRadioButton(tr("Auto detect data sizes"), this);
	rA->setChecked(true);	o->addWidget(rA);
	rM = new QRadioButton(tr("Set data sizes manually"), this);
	o->addWidget(rM);	a = new QHBoxLayout;	o->addLayout(a);
	l = new QLabel(tr("Nx"));	a->addWidget(l);
	nx = new QLineEdit("1",this);	a->addWidget(nx);
	l = new QLabel(tr("Ny"));	a->addWidget(l);
	ny = new QLineEdit("1",this);	a->addWidget(ny);
	l = new QLabel(tr("Nz"));	a->addWidget(l);
	nz = new QLineEdit("1",this);	a->addWidget(nz);
	r2 = new QRadioButton(tr("Matrix with sizes from file"), this);	o->addWidget(r2);
	r3 = new QRadioButton(tr("3D data with sizes from file"), this);o->addWidget(r3);

	a = new QHBoxLayout;	o->addLayout(a);
	b = new QPushButton(tr("Cancel"),this);	a->addWidget(b);
	connect(b,SIGNAL(clicked()),this,SLOT(reject()));
	b = new QPushButton(tr("OK"), this);	a->addWidget(b);
	connect(b, SIGNAL(clicked()),this, SLOT(prepareResult()));
	b->setDefault(true);
}
//-----------------------------------------------------------------------------
DataOpenDialog::~DataOpenDialog(){}
//-----------------------------------------------------------------------------
void DataOpenDialog::prepareResult()
{
	code = "";	numDataOpened++;	data = name->text();
	// prepare unique value of name for next time
	char buf[32];	sprintf(buf,"mgl_%d",numDataOpened);	name->setText(buf);
	mglVar *v = parser.AddVar(data.toAscii());
	if(rA->isChecked())	//	auto sizes
	{
		setlocale(LC_ALL, "C");	v->d.Read(file.toAscii().constData());	setlocale(LC_ALL, "");
		if(v->d.nz>1)
			code=QString("#read %1 '%2'\nrotate 40 60\ncrange %1:box\nsurf3 %1\n").arg(data).arg(file);
		else if(v->d.ny>1)
			code=QString("#read %1 '%2'\nrotate 40 60\ncrange %1:zrange %1:box\nsurf %1\n").arg(data).arg(file);
		else
			code=QString("#read %1 '%2'\nyrange %1:box\nplot %1\n").arg(data).arg(file);
	}
	else if(rM->isChecked())	//	manual sizes
	{
		int x=nx->text().toInt(), y=ny->text().toInt(), z=nz->text().toInt();
		setlocale(LC_ALL, "C");	v->d.Read(file.toAscii().constData(),x,y,z);	setlocale(LC_ALL, "");
		if(v->d.nz>1)
			code=QString("#read %1 '%2' %3 %4 %5\nrotate 40 60\ncrange %1:box\nsurf3 %1\n")
						.arg(data).arg(file).arg(x).arg(y).arg(z);
		else if(v->d.ny>1)
			code=QString("#read %1 '%2' %3 %4 %5\nrotate 40 60\ncrange %1:zrange %1:box\nsurf %1\n")
						.arg(data).arg(file).arg(x).arg(y).arg(z);
		else
			code=QString("#read %1 '%2' %3 %4 %5\nyrange %1:box\nplot %1\n")
						.arg(data).arg(file).arg(x).arg(y).arg(z);
	}
	else if(r2->isChecked())	//	matrix
	{
		setlocale(LC_ALL, "C");	v->d.ReadMat(file.toAscii().constData());	setlocale(LC_ALL, "");
		code=QString("#readmat %1 '%2'\nrotate 40 60\ncrange %1:zrange %1:box\nsurf %1\n").arg(data).arg(file);
	}
	else if(r3->isChecked())	//	3d-data
	{
		setlocale(LC_ALL, "C");	v->d.ReadMat(file.toAscii().constData(),3);	setlocale(LC_ALL, "");
		code=QString("#readmat %1 '%2' 3\nrotate 40 60\ncrange %1:box\nsurf3 %1\n").arg(data).arg(file);
	}
	accept();
}
//-----------------------------------------------------------------------------
void DataOpenDialog::setFile(const QString &fname)
{
	file=fname;
	mglData d(file.toAscii().constData());
	rA->setText(tr("Auto detect data sizes (%1 x %2 x %3)")
				.arg(d.nx).arg(d.ny).arg(d.nz));
}
//-----------------------------------------------------------------------------
