#include "cs_mex.h"
/* cs_chol: sparse Cholesky factorization */
void mexFunction (int nargout, mxArray *pargout [ ], int nargin,
    const mxArray *pargin [ ])
{
    cs Amatrix, *A ;
    int order, n, drop, *P ;
    css *S ;
    csn *N ;
    if (nargout > 2 || nargin < 1 || nargin > 2)
	mexErrMsgTxt ("Usage: [L,p] = cs_chol(A,drop)") ;
    A = cs_get_sparse (&Amatrix, 1, 1, pargin [0]) ;	/* get A */
    n = A->n ;
    order = (nargout > 1) ? 0 : -1 ;		    /* determine ordering */
    S = cs_schol (A, order) ;			    /* symbolic Cholesky */
    N = cs_chol (A, S) ;			    /* numeric Cholesky */
    if (!N) mexErrMsgTxt ("cs_chol failed: not positive definite\n") ;
    drop = (nargin == 1) ? 1 : mxGetScalar (pargin [1]) ;
    if (drop) cs_dropzeros (N->L) ;		    /* drop zeros if requested*/
    pargout [0] = cs_put_sparse (&(N->L)) ;	    /* return L */
    if (nargout > 1)
    {
	P = cs_pinv (S->Pinv, n) ;		    /* P=Pinv' */
	pargout [1] = cs_put_int (P, n, 1, 1) ;	    /* return P */
    }
    cs_nfree (N) ;
    cs_sfree (S) ;
}
