/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DBXREF_H_
#define _GB2_DBXREF_H_

#include <core_api/core_api.h>

#include <QtCore/QMap>
#include <QtCore/QObject>
#include <QtCore/QStringList>

namespace GB2 {

class DBXRefInfo {
public:
    DBXRefInfo(){};
    DBXRefInfo(const QString& _name, const QString& _url, 
               const QString& _fileUrl, const QString& _comment) 
               : name(_name), url(_url), fileUrl(_fileUrl), comment(_comment){}

    QString name;
    QString url;
    QString fileUrl;
    QString comment;
};

class GB2_COREAPI_EXPORT DBXRefRegistry : public QObject {
    Q_OBJECT
public:
    DBXRefRegistry(QObject* p = NULL);
	
    DBXRefInfo getRefByKey(const QString& dbxrefKey)const {return refsByKey.value(dbxrefKey);}

private:
	QMap<QString,DBXRefInfo> refsByKey;
};

}//namespace

#endif
