/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GHINTS_H_
#define _GB2_GHINTS_H_

#include <core_api/core_api.h>

#include <QtCore/QVariantMap>

namespace GB2 {

class GB2_COREAPI_EXPORT GHints {
public:
    virtual ~GHints(){};

    virtual QVariantMap getMap() const  = 0;

    virtual void setMap(const QVariantMap& map) = 0;

    virtual QVariant get(const QString& key) const = 0;

    virtual void set(const QString& key, const QVariant& val) = 0;

    virtual int remove(const QString& key) = 0;
};

class GHintsDefaultImpl : public GHints {
public:
    GHintsDefaultImpl(const QVariantMap& _map = QVariantMap()) : map(_map) {}
    virtual QVariantMap getMap() const {return map;}

    virtual void setMap(const QVariantMap& _map) {map = _map;}

    virtual QVariant get(const QString& key) const  {return map.value(key);}

    virtual void set(const QString& key, const QVariant& val) {map[key] = val;}

    virtual int remove(const QString& key) {return map.remove(key);}

protected:
    QVariantMap map;
};

}//namespace

#endif
