/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "IOAdapter.h"

#include <core_api/AppContext.h>
#include <memory>

namespace GB2 {

const IOAdapterId BaseIOAdapters::LOCAL_FILE("local_file");
const IOAdapterId BaseIOAdapters::GZIPPED_LOCAL_FILE("local_file_gzip");
const IOAdapterId BaseIOAdapters::HTTP_FILE( "http_file" );
const IOAdapterId BaseIOAdapters::GZIPPED_HTTP_FILE( "http_file_gzip" );

static bool isHyperLink( const QString & str ) {
    return str.startsWith("http://") || str.startsWith("https://");
}

IOAdapterId BaseIOAdapters::url2io(const QString& url) {
    if( isHyperLink(url) ) {
        if( url.endsWith(".gz") ) {
            return BaseIOAdapters::GZIPPED_HTTP_FILE;
        }
        return BaseIOAdapters::HTTP_FILE;
    }
    if( url.endsWith(".gz") ) {
        return BaseIOAdapters::GZIPPED_LOCAL_FILE;
    }
    return BaseIOAdapters::LOCAL_FILE;
}

QByteArray BaseIOAdapters::readFileHeader(const QString& url, int size) {
    QByteArray data;
    IOAdapterFactory* iof = AppContext::getIOAdapterRegistry()->
        getIOAdapterFactoryById(BaseIOAdapters::url2io(url));
    std::auto_ptr<IOAdapter> adapter(iof->createIOAdapter());
    bool res = adapter->open(url, IOAdapterMode_Read);
    if (!res) {
        return data;//BUG:420: report error
    }

    data.resize(size);

    int s = adapter->readBlock(data.data(), data.size());
    if (s == -1) {
        data.resize(0);
        return data;//BUG:420: report error
    }

    if (s != data.size()) {
        data.resize(s);
    }
    return data;
}

#if 0
qint64 IOAdapter::readUntil(char* buff, qint64 maxSize, 
							const QBitArray& readTerminators, 
							TerminatorHandling th,  bool* terminatorFound) 
{
	int i = 0;
	for(; i < maxSize; i++) {
		char c;
		bool eof = !getChar(&c);
		if (eof) {
			break;
		}
		if (readTerminators[(uchar)c]) {
			if (terminatorFound!=NULL) {
				*terminatorFound = true;
			}
			if (th == Term_Include) {
				buff[i] = c;
				while (++i < maxSize) {
					eof = !getChar(&c);
					if (eof) {
						break;
					}
					if (!readTerminators[(uchar)c]) {
						break;
					}
					buff[i] = c;
				}
			} 
			if (!eof) {
				//f->ungetChar(c);
				skip(-1);
			}
			break;
		}
		buff[i] = c;
	}
	return i;
}
#else
qint64 IOAdapter::readUntil(char* buf, qint64 maxSize, 
							const QBitArray& readTerminators, 
							TerminatorHandling th,  bool* terminatorFound) 
{
	const qint64 CHUNK = (qint64)1024;
	const char *chunk_start, *start = buf, *end = buf + maxSize;
	
	bool found = false;
	qint64 len;
	do {
		chunk_start = buf;
		len = readBlock(buf, qMin(CHUNK, (qint64)end - (qint64)buf));
		if (len < CHUNK) {
			// last chunk, no more data or buffer space
			end = buf + len;
		}
		for(; buf < end; buf++) {
			// loop exit invariant: buf is positioned after last accepted char
			if (readTerminators[(uchar)*buf]) {
				found = true;
				if (th == Term_Exclude) {
					break;
				}
			} else if (found) {
				assert(th == Term_Include);
				break;
			}
		}
	} while (!found && buf < end);
	
	if (found) {
		bool b = skip((qint64)buf - (qint64)chunk_start - len);
		assert(b);// Cannot put back unused data;
	}

	if (terminatorFound != NULL) {
		*terminatorFound = found;
	}

	return (qint64)buf - (qint64)start;
}

#endif

}//namespace
