/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_CHROMATOGRAM_H_
#define _GB2_DNA_CHROMATOGRAM_H_

#include <QtCore/QVector>
#include <core_api/core_api.h>

namespace GB2 {

class GB2_COREAPI_EXPORT DNAChromatogram {
public:
    DNAChromatogram() : traceLength(0), seqLength(0), hasQV(false) {}
    int traceLength;
	int seqLength;
    QVector<ushort> baseCalls;
    QVector<ushort> A;
    QVector<ushort> C;
    QVector<ushort> G;
    QVector<ushort> T;
	QVector<char> prob_A;
	QVector<char> prob_C;
	QVector<char> prob_G;
	QVector<char> prob_T;
	bool hasQV;
};

} //namespace

#endif
