/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PHYTREE_H_
#define _GB2_PHYTREE_H_

#include <core_api/core_api.h>

#include <QtCore/QSet>
#include <QtCore/QSharedData>

namespace GB2 {

class PhyBranch;
class PhyNode;

class GB2_COREAPI_EXPORT PhyTreeData : public QSharedData {
public:
    PhyTreeData();
    PhyTreeData(const PhyTreeData& other);

    void validate() const;

    PhyNode* rootNode;
};
typedef QSharedDataPointer<PhyTreeData> PhyTree;

class GB2_COREAPI_EXPORT PhyNode {
public:
    PhyNode();
    
    void validate(QList<const PhyNode*>& track) const;
    bool isConnected(const PhyNode* node) const;

    static PhyBranch* addBranch(PhyNode* node1, PhyNode* node2, double distance);
    static void removeBranch(PhyNode* node1, PhyNode* node2);

    PhyNode* clone() const;
    void addToTrack(QSet<const PhyNode*>& track) const;

    QString             name;
    QList<PhyBranch*>   branches;

};

class GB2_COREAPI_EXPORT PhyBranch {
public:
    PhyBranch();
    
    PhyNode* node1;
    PhyNode* node2;
    double   distance;
};

}//namespace

#endif

