/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ABI_FORMAT_H_
#define _GB2_ABI_FORMAT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>

namespace GB2 {

class IOAdapter;
class SeekableBuf;

class GB2_COREAPI_EXPORT  ABIFormat : public DocumentFormat {
    Q_OBJECT
public:
	ABIFormat(QObject* p);

	virtual DocumentFormatId getFormatId() const {return BaseDocumentFormats::ABIF;}

	virtual const QString& getFormatName() const {return formatName;}

	virtual QStringList getSupportedDocumentFileExtensions();

	virtual Document* loadExistingDocument(IOAdapterFactory* io, const QString& url, TaskStateInfo& ti, const QVariantMap& fs);

	virtual void storeDocument(Document* d, TaskStateInfo& ti, IOAdapterFactory* io = NULL, const QString& newDocURL = QString::null);

	virtual bool isObjectOpSupported(const Document* d , DocumentFormat::DocObjectOp op, GObjectType t) const;
	    
    virtual bool isDataFormatSupported(const char* data, int size) const;

	virtual bool checkConstraints(const DocumentFormatConstraints& c) const;

private:
    Document* parseABI(SeekableBuf*, IOAdapterFactory* io, const QString& url, const QVariantMap& fs);
	QString formatName;
};

}//namespace

#endif
