/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GOBJECT_UTILS_H_
#define _GB2_GOBJECT_UTILS_H_

#include "GObjectTypes.h"
#include <core_api/GObject.h>

namespace GB2 {

class AnnotationTableObject;
class DNASequenceObject;
class DNATranslation;

class GB2_COREAPI_EXPORT GObjectUtils {
public:
	
	inline static QList<GObject*>	select(const QList<GObject*>& objects, GObjectType type);

	inline static GObject*			selectOne(const QList<GObject*>& objects, GObjectType type);

    static QList<GObject*>          findAllObjects(GObjectType t = GObjectType());

    static QSet<GObject*>           selectRelations(GObject* obj, GObjectType type, const QString& relationRole, 
                                        const QList<GObject*>& fromObjects);

    static QList<GObject*>          findObjectsRelatedToObjectByRole(const GObject* obj, GObjectType resultObjType, 
                                        const QString& relationRole, const QList<GObject*>& fromObjects);

    static QList<GObject*>          selectObjectsWithRelation(const QList<GObject*>& objs, GObjectType type, 
                                        const QString& relationRole, bool allowUnloadedRelations);

    static GObject*                 selectObjectByReference(const GObjectReference& r, const QList<GObject*>& fromObjects);

    static DNATranslation*          findComplementTT(DNASequenceObject* so);

    static DNATranslation*          findAminoTT(DNASequenceObject* so, bool fromHintsOnly);
};

inline QList<GObject*> GObjectUtils::select(const QList<GObject*>& objects, GObjectType type) {
    if (type.isEmpty()) {
        return objects;
    }
	QList<GObject*> res;
	foreach(GObject* obj, objects) {
		if (obj->getGObjectType() == type) {
			res.append(obj);
		}
	}
	return res;
}

inline GObject* GObjectUtils::selectOne(const QList<GObject*>& objects, GObjectType type) {
	QList<GObject*> res = select(objects, type);
	if (res.size() == 0) {
		return NULL;
	}
	assert(res.size() == 1);
	return res.first();
}


} // namespace

#endif
