/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_UTILS_H_
#define _GB2_MSA_UTILS_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

namespace GB2 {

class MAlignment;

enum MSAConsensusType {
    MSAConsensusType_Default,
    MSAConsensusType_ClustalW
};

class GB2_COREAPI_EXPORT MSAUtils {
public:


    static void updateConsensus(const MAlignment& msa, QByteArray& cons, MSAConsensusType ctype);

    static void updateConsensus(const MAlignment& msa, const LRegion& region, QByteArray& cons, MSAConsensusType ctype);

    static void updateConsensus(const MAlignment& msa, const QList<LRegion>& region, QByteArray& cons, MSAConsensusType ctype);
};


}//namespace

#endif
