/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADD_EXISTING_DOCUMENT_DIALOG_IMPL_H_
#define _GB2_ADD_EXISTING_DOCUMENT_DIALOG_IMPL_H_

#include <core_api/core_api.h>
#include <core_api/DocumentModel.h>

#include <ui/ui_AddExistingDocumentDialog.h>

namespace GB2 {

class DocumentFormatComboboxController;
class SupportedFormatsFilter;

class GB2_COREAPI_EXPORT AddExistingDocumentDialogModel {
public:
	AddExistingDocumentDialogModel(const QString& _url = QString::null,  
		DocumentFormatId _format = DocumentFormatId::null, bool _readOnly = false)
		: url(_url), io(IOAdapterId::null), format(_format), readOnly(_readOnly), successful(false){}
	
	QString				url;
	IOAdapterId         io;
	DocumentFormatId	format;	
	bool				readOnly;
    QVariantMap         formatSettings;
	bool				successful;
    QString             dwnldPath;    
};


class GB2_COREAPI_EXPORT AddExistingDocumentDialogImpl : public QDialog, public Ui::AddExistingDocumentDialog {
	Q_OBJECT

	AddExistingDocumentDialogImpl(QWidget* p,  AddExistingDocumentDialogModel& m);

public:

	static void run(QWidget* p, AddExistingDocumentDialogModel& m_, bool runFileDialog = false);

private slots:
	void sl_documentURLButtonClicked();
	void sl_addButtonClicked();
	void sl_customFormatSettingsClicked();
	void sl_documentURLEditFinished();
    void sl_documentURLTextEdited(const QString&);
	void sl_formatComboCurrentChanged(int i);

private:
    static QString selectFile(QWidget* p);

	void updateState();
	void updateAvailableFormats();

    AddExistingDocumentDialogModel model;
	DocumentFormatComboboxController* formatController;
	SupportedFormatsFilter* filter;

};

} //namespace

#endif

