/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADD_NEW_DOCUMENT_DIALOG_IMPL_H_
#define _GB2_ADD_NEW_DOCUMENT_DIALOG_IMPL_H_

#include <core_api/core_api.h>
#include <core_api/DocumentModel.h>

#include "../_tmp/ui/ui_AddNewDocumentDialog.h"

namespace GB2 {

class DocumentFormatComboboxController;

class GB2_COREAPI_EXPORT AddNewDocumentDialogModel {
public:
	AddNewDocumentDialogModel(const QString& _url = QString::null, DocumentFormatId _format = DocumentFormatId::null)
		: url(_url), io(IOAdapterId::null), format(_format), successful(false){}
	
	QString				url;
	IOAdapterId         io;
	DocumentFormatId	format;
	bool				successful;

};

class GB2_COREAPI_EXPORT AddNewDocumentDialogImpl : public QDialog, public Ui::AddNewDocumentDialog {
	Q_OBJECT
	AddNewDocumentDialogImpl(QWidget* p, AddNewDocumentDialogModel& m, const DocumentFormatConstraints& c);
public:
	static void run(QWidget* p, AddNewDocumentDialogModel& m, const DocumentFormatConstraints& c);

private slots:
	void sl_documentURLButtonClicked();
	void sl_createButtonClicked();
	void sl_documentURLEdited();
	void sl_typeComboCurrentChanged(int i);
	void sl_gzipChecked(bool state);

private:
	void updateState();
	QString currentURL();
	

	AddNewDocumentDialogModel model;
	DocumentFormatComboboxController* formatController;
};


}//namespace

#endif
