/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ProjectTreeItemSelectorDialog.h"
#include "ProjectTreeController.h"

#include <QtGui/QTreeWidget>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QSpacerItem>
#include <QtGui/QPushButton>

namespace GB2 {

ProjectTreeItemSelectorDialog::ProjectTreeItemSelectorDialog(const ProjectTreeControllerModeSettings& s) {
    setupUi(this);
    controller = new ProjectTreeController(this, treeWidget, s);
}

ProjectTreeItemSelectorDialog::~ProjectTreeItemSelectorDialog() {
    delete controller;
}

QList<Document*> ProjectTreeItemSelectorDialog::selectDocuments(const ProjectTreeControllerModeSettings& s) {
    QList<Document*> res;
    ProjectTreeItemSelectorDialog d(s);
    int rc = d.exec();
    if (rc == QDialog::Accepted) {
        const DocumentSelection* ds = d.controller->getDocumentSelection();
        res << ds->getSelectedDocuments();
    }
    return res;    
}

QList<GObject*> ProjectTreeItemSelectorDialog::selectObjects(const ProjectTreeControllerModeSettings& s) {
    QList<GObject*> res;
    ProjectTreeItemSelectorDialog d(s);
    int rc = d.exec();
    if (rc == QDialog::Accepted) {
        const GObjectSelection* os = d.controller->getGObjectSelection();
        res << os->getSelectedObjects();
    }
    return res;
}

}//namespace
