/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "RangeSelector.h"

#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QToolButton>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QIntValidator>
#include <math.h>

namespace GB2 {
	
RangeSelector::RangeSelector(QWidget* p, int s, int e) 
: QWidget(p), rangeStart(s), rangeEnd(e), startEdit(NULL), endEdit(NULL), dialog(NULL), autoclose(false) 
{
    init();	    

    QToolButton* goButton = new QToolButton(this);
    goButton->setText(tr("Ok"));
    connect(goButton, SIGNAL(clicked(bool)), SLOT(sl_onGoButtonClicked(bool)));

    layout()->addWidget(goButton);
}

void RangeSelector::init() {
    int w = qMax(((int)log10((double)rangeEnd))*10, 70);

    startEdit = new QLineEdit(this);
	startEdit->setValidator(new QIntValidator(rangeStart, rangeEnd, startEdit));
    if (dialog == NULL) {
	    startEdit->setFixedWidth(w);
    } else {
        startEdit->setMinimumWidth(w);
    }

	startEdit->setAlignment(Qt::AlignRight);
	connect(startEdit, SIGNAL(returnPressed()), SLOT(sl_onReturnPressed()));

    endEdit = new QLineEdit(this);
	endEdit->setValidator(new QIntValidator(rangeStart, rangeEnd, startEdit));
    if (dialog == NULL) {
    	endEdit->setFixedWidth(w);
    } else {
        endEdit->setMinimumWidth(w);
    }

	endEdit->setAlignment(Qt::AlignRight);
	connect(endEdit, SIGNAL(returnPressed()), SLOT(sl_onReturnPressed()));

	QToolButton* minButton = new QToolButton(this);
	minButton->setText(tr("min"));
    connect(minButton, SIGNAL(clicked(bool)), SLOT(sl_onMinButtonClicked(bool)));

	QToolButton* maxButton = new QToolButton(this);
	maxButton->setText(tr("max"));
    connect(maxButton, SIGNAL(clicked(bool)), SLOT(sl_onMaxButtonClicked(bool)));

	QHBoxLayout* l = new QHBoxLayout(this);
    if (dialog == NULL) {
    	l->setContentsMargins(5, 0, 5, 0);
        l->setSizeConstraint(QLayout::SetFixedSize);
    } else {
        l->setMargin(0);
    }

	setLayout(l);

    QLabel* rangeLabel = new QLabel(tr("range_label"), this);
    rangeLabel->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred);

	l->addWidget(rangeLabel);
	l->addWidget(minButton);
	l->addWidget(startEdit);
	l->addWidget(new QLabel(tr("-"), this));
	l->addWidget(endEdit);
	l->addWidget(maxButton);
}

RangeSelector::RangeSelector(QDialog* d, int s, int e, bool a) 
: QWidget(d), rangeStart(s), rangeEnd(e), startEdit(NULL), endEdit(NULL), dialog(d), autoclose(a)
{
    init();

    QPushButton* okButton = new QPushButton(this);
    okButton->setText(tr("Ok"));
    okButton->setDefault(true);
    connect(okButton, SIGNAL(clicked(bool)), SLOT(sl_onGoButtonClicked(bool)));

    QPushButton* cancelButton = new QPushButton(this);
    cancelButton->setText(tr("Cancel"));
    connect(cancelButton, SIGNAL(clicked()), d, SLOT(reject()));

    QHBoxLayout* l3 = new QHBoxLayout();
    l3->setMargin(0);
    l3->addStretch();
    l3->addWidget(cancelButton);
    l3->addWidget(okButton);

    assert(dialog!=NULL);
    QVBoxLayout* l2 = new QVBoxLayout();
    l2->addWidget(this);
    l2->addStretch();
    l2->addLayout(l3);

    dialog->setLayout(l2);
    dialog->resize(l2->minimumSize());
}


RangeSelector::~RangeSelector(){ 
//	printf("DELETED\n");
}


void RangeSelector::sl_onGoButtonClicked(bool checked) {
    Q_UNUSED(checked);
	exec();
}

void RangeSelector::sl_onReturnPressed() {
	exec();
}

void RangeSelector::exec() {
	bool ok = false;
	int v1 = startEdit->text().toInt(&ok);
	if (!ok || v1 < rangeStart || v1 > rangeEnd) {
		return;
	}
	int v2 = endEdit->text().toInt(&ok);
	if (!ok || v2 < v1 || v2 > rangeEnd) {
		return;
	}
	
    emit si_rangeChanged(v1, v2);

    if (dialog!=NULL && autoclose) {
        dialog->accept();
    }
}

void RangeSelector::sl_onMinButtonClicked(bool checked) {
    Q_UNUSED(checked);
	startEdit->setText(QString::number(rangeStart));
}

void RangeSelector::sl_onMaxButtonClicked(bool checked) {
    Q_UNUSED(checked);
	endEdit->setText(QString::number(rangeEnd));
}


int RangeSelector::getStart() const {
    bool ok = false;
    int v = startEdit->text().toInt(&ok);
    assert(ok);
    return v;
}

int RangeSelector::getEnd() const {
    bool ok = false;
    int v = endEdit->text().toInt(&ok);
    assert(ok);
    return v;
}

} //namespace
