/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_STATE_H_
#define _GB2_MSA_EDITOR_STATE_H_

#include <core_api/LRegion.h>
#include <core_api/GObject.h>

#include <QtCore/QVariant>

namespace GB2 {

class MSAEditor;	


class GB2_COREAPI_EXPORT MSAEditorState {
public:
	MSAEditorState(){}

	MSAEditorState(const QVariantMap& _stateData) : stateData(_stateData){}

	static QVariantMap saveState(MSAEditor* v);

	bool isValid() const;
	
	GObjectReference getMSAObject() const;

	void setMSAObject(const GObjectReference& ref);
	
	int getX() const;

	void setX(int x);

	int getY() const;

	void setY(int y);

	QVariantMap stateData;
};




} // namespace

#endif
