/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_OBJECT_VIEW_TASKS_H_
#define _GB2_OBJECT_VIEW_TASKS_H_

#include <core_api/Task.h>
#include <core_api/ObjectViewModel.h>

#include <QtCore/QPointer>

namespace GB2 {

class Document;

class GB2_COREAPI_EXPORT ObjectViewTask : public Task {
    Q_OBJECT
public:
	enum Type {
		Type_Open,
		Type_Update
	};

	ObjectViewTask(GObjectView* view, const QString& stateName, const QVariantMap& s = QVariantMap());

	ObjectViewTask(GObjectViewFactoryId fid, const QString& viewName = QString(), const QVariantMap& s = QVariantMap());

	virtual void prepare();
	virtual ReportResult report();

	
	virtual void open(){};
	virtual void update(){};
	
	virtual void onDocumentLoaded(Document* d){ Q_UNUSED(d); }

protected:
	Type					taskType;
	QVariantMap				stateData;
	QPointer<GObjectView>	view;
	QString					viewName;
	bool					stateIsIllegal;
	QStringList				objectsNotFound;
	QStringList				documentsNotFound;


	QList<QPointer<Document> > documentsToLoad;
	QList<QPointer<Document> > documentsFailedToLoad;

	QList<QPointer<GObject> > selectedObjects;
};



} // namespace


#endif
