/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SEQUENCE_WALKER_TASK_H_
#define _GB2_SEQUENCE_WALKER_TASK_H_

#include <core_api/Task.h>
#include <core_api/LRegion.h>

namespace GB2 {

class DNATranslation;
class SequenceWalkerSubtask;

class GB2_COREAPI_EXPORT SequenceWalkerConfig {
public:
    
    //TODO: allow select custom strand only!

    SequenceWalkerConfig() : seq(NULL), seqSize(0), complTrans(NULL), aminoTrans(NULL), 
        chunkSize(0), overlapSize(0), exOverlapSize(0), parallel(false), maxThreads(1) {}

    const char*     seq;
    int             seqSize;
    DNATranslation* complTrans;
    DNATranslation* aminoTrans;
    
    int				chunkSize;
    int				overlapSize;
    int				exOverlapSize;
    bool			parallel;
	int				maxThreads;
};

class GB2_COREAPI_EXPORT SequenceWalkerCallback {
public:
    virtual ~SequenceWalkerCallback(){}

    virtual void onRegion(SequenceWalkerSubtask* t, TaskStateInfo& ti) = 0;
};

class GB2_COREAPI_EXPORT SequenceWalkerTask : public Task {
    Q_OBJECT
public:
    SequenceWalkerTask(const SequenceWalkerConfig& config, SequenceWalkerCallback* callback, 
        const QString& name, TaskFlags tf = TaskFlags_NR_DWF | TaskFlags_FAIL_OSCOE);
    
    SequenceWalkerCallback*     getCallback() const {return callback;}
    const SequenceWalkerConfig& getConfig() const {return config;}

    static QList<LRegion> splitRange(const LRegion& range, int chunkSize, int overlapSize, int exOverlapSize, int normK, bool revertNorm);

    void setError(const QString& err) {stateInfo.error = err;}

private:
    QList<SequenceWalkerSubtask*> prepareSubtasks();
    QList<SequenceWalkerSubtask*> createSubs(const QList<LRegion>& chunks, bool doCompl, bool doAmino);

    SequenceWalkerConfig    config;
    SequenceWalkerCallback* callback;
	QList<SequenceWalkerSubtask*> swSubTasks;
	QList<SequenceWalkerSubtask*> runningSubTasks;
protected:
	virtual QList<Task*> onSubTaskFinished(Task* subTask);
};


class GB2_COREAPI_EXPORT SequenceWalkerSubtask : public Task {
    Q_OBJECT
public:
    SequenceWalkerSubtask(SequenceWalkerTask* t, const LRegion& globalReg, const char* localSeq, int localLen, bool doCompl, bool doAmino);
    void run();
    
    const char* getRegionSequence();
    
    int  getRegionSequenceLen();
    
    bool isDNAComplemented() const {return doCompl;}
    
    bool isAminoTranslated() const {return doAmino;}
    
    LRegion getGlobalRegion() const {return globalRegion;}
    
    const SequenceWalkerConfig& getGlobalConfig() const {return t->getConfig();}

private:
    bool needLocalRegionProcessing() const {return (doAmino || doCompl) && processedSeqImage.isEmpty();}
    void prepareLocalRegion();

    SequenceWalkerTask*     t;
    LRegion                 globalRegion;
    const char*             localSeq;
    const char*             originalLocalSeq;
    int                     localLen;
    int                     originalLocalLen;
    bool                    doCompl;
    bool                    doAmino;
    
    QByteArray              processedSeqImage;

};


}//namespace

#endif
