/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Attribute.h"

#include <workflow_support/WorkflowUtils.h>
#include <QtCore/QStringList>
#include "ConfigurationEditor.h"

namespace GB2 {

bool Configuration::validate(QStringList& l) const {
    bool good = true;
    foreach(Attribute* a, getParameters()) {
        if (a->required && (!a->value.isValid() || a->value.isNull())) 
        {
            good = false;
            l.append(GB2::DesignerUtils::tr("Required parameter is not set: %1").arg(a->getDisplayName()));
        }
    }
    if (validator) {
        good &= validator->validate(this, l);
    }
    return good;
}

Configuration::~Configuration()
{
    qDeleteAll(params.values());
}
}//namespace
