/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_CFG_EDITOR_H_
#define _GB2_WORKFLOW_CFG_EDITOR_H_

#include <workflow/Attribute.h>

#include <QtGui/QItemDelegate>

class QWidget;

namespace GB2 {

class ConfigurationEditor;
class PropertyDelegate;

class WCOREAPI_EXPORT ConfigurationEditor {
public:
    enum ItemValueRole {
        ItemValueRole = Qt::UserRole + 2,
        ItemListValueRole
    };

    virtual QWidget* getWidget() {return NULL;}
    virtual PropertyDelegate* getDelegate(const QString&) {return NULL;}
    virtual void commit() {}
    virtual ~ConfigurationEditor() {}
};

class WCOREAPI_EXPORT PropertyDelegate : public QItemDelegate {
public:
    PropertyDelegate(QObject * parent = 0) : QItemDelegate(parent) {}
    virtual ~PropertyDelegate() {}
    virtual QVariant getDisplayValue(const QVariant& v) const {return v;}
};
}//GB2 namespace

#endif
