/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_BUS_MODEL_H_
#define _GB2_WORKFLOW_BUS_MODEL_H_

#include <workflow/WorkflowModel.h>

namespace GB2 {
namespace Workflow {

class WCOREAPI_EXPORT BusPort : public Port {
    Q_OBJECT
public:
    static const QString BUS_MAP;
    BusPort(const PortDescriptor& d, Actor* p);
    virtual DataTypePtr getType() const;
    DataTypePtr getOwnType() const {return type;}
    Actor* getProducer(const QString& slot);
    QList<Actor*> getProducers(const QString& slot);

    void setupBusMap();

    virtual bool validate(QStringList&) const;
    virtual void remap(const QMap<ActorId, ActorId>&);

protected:
    virtual DataTypePtr getBusType() const;
    mutable bool recursing;
};

class WCOREAPI_EXPORT BusActorPrototype : public ActorPrototype {
public:
    BusActorPrototype(const Descriptor& desc, 
        const QList<PortDescriptor*>& ports = QList<PortDescriptor*>(), 
        const QList<Attribute*>& attrs = QList<Attribute*>()) : ActorPrototype(desc, ports, attrs) {}

    virtual Port* createPort(const PortDescriptor& d, Actor* p) {return new BusPort(d, p);}
};

}//namespace Workflow
}//namespace GB2

typedef QMap<QString, QString> QStrStrMap;
Q_DECLARE_METATYPE(QStrStrMap)

#endif
