/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PLAINBUS_TYPE_H_
#define _GB2_PLAINBUS_TYPE_H_

#include <workflow/TypeSet.h>
#include <workflow/IntegralBusModel.h>

namespace GB2 {
namespace Workflow {

class WCOREAPI_EXPORT IntegralBusType : public DataTypeSet {
public:
    IntegralBusType(const Descriptor& d, const QMap<Descriptor, DataTypePtr>& m) : DataTypeSet(d, m) {}

    void addInputs(const Port* p);
    void addOutput(DataTypePtr, const Port* producer);

    static Descriptor assignSlotDesc(const Descriptor& elementDesc, const Port* producer);
    static void remap(QStrStrMap& busMap, const QMap<ActorId, ActorId>&);
    static ActorId parseSlotDesc(const QString& id);

    //QMap<Descriptor, DataTypePtr> findMatches(const Descriptor& d, DataTypePtr t);
    
protected:
    //QMap<Descriptor, DataTypePtr> map;
};

} //namespace Workflow
} //namespace GB2
#endif
