/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "BioActorLibrary.h"

#include <workflow/WorkflowEnv.h>

#include "BioDatatypes.h"
#include "LocalDomain.h"

namespace GB2 {
namespace Workflow {

    const QString BioActorLibrary::SEQ_SLOT_ID("sequence");
    const QString BioActorLibrary::MA_SLOT_ID("malignment");
    const QString BioActorLibrary::FEATURE_TABLE_SLOT_ID("feature-table");
    const Descriptor BioActorLibrary::SEQ_SLOT() {return Descriptor(SEQ_SLOT_ID, tr("Sequence"), tr("A biological sequence"));}
    const Descriptor BioActorLibrary::MA_SLOT() {return Descriptor(MA_SLOT_ID, tr("Multiple alignment"), tr("A multiple sequence alignment"));}
    const Descriptor BioActorLibrary::FEATURE_TABLE_SLOT() {return Descriptor(FEATURE_TABLE_SLOT_ID, tr("Set of annotations"), tr("A set of annotated regions"));}

void BioActorLibrary::init() {

    WorkflowEnv::getDomainRegistry()->registerEntry(new LocalWorkflow::LocalDomainFactory());
}

}//Workflow namespace
}//GB2 namespace
