/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_BASE_LIB_H_
#define _GB2_WORKFLOW_BASE_LIB_H_

#include <workflow/Datatype.h>

namespace GB2 {
namespace Workflow {

class WCOREAPI_EXPORT BioActorLibrary : public QObject {
    Q_OBJECT
public:
    static const Descriptor CATEGORY_DATASRC(){return Descriptor("a", tr("Data sources"), "");}
    static const Descriptor CATEGORY_DATASINK(){return Descriptor("b", tr("Data sinks"), "");}
    static const Descriptor CATEGORY_OTHER(){return Descriptor("z", tr("Other"), "");}
    static const Descriptor CATEGORY_BASIC(){return Descriptor("c", tr("Basic analysis"), "");}
    static const Descriptor CATEGORY_ALIGNMENT(){return Descriptor("d", tr("Multiple sequence alignment"), "");}

    static const QString SEQ_SLOT_ID;
    static const QString MA_SLOT_ID;
    static const QString FEATURE_TABLE_SLOT_ID;
    static const Descriptor SEQ_SLOT();
    static const Descriptor MA_SLOT();
    static const Descriptor FEATURE_TABLE_SLOT();

    static void init();
};

}//Workflow namespace
}//GB2 namespace

#endif
