/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_SERIALIZER_H_
#define _GB2_WORKFLOW_SERIALIZER_H_

#include <workflow/WorkflowModel.h>
#include <workflow/Schema.h>

class QDomDocument;
class QDomElement;

namespace GB2 {
namespace Workflow {

class WCOREAPI_EXPORT SchemaSerializer : public QObject {
    Q_OBJECT
public:
    static const QString WORKFLOW_DOC;

    static void saveConfiguration(const Configuration&, QDomElement& );
    static void readConfiguration(Configuration*, const QDomElement& );
    static void saveIterations(const QList<Iteration>&, QDomElement& );
    static void readIterations(QList<Iteration>&, const QDomElement&,const QMap<ActorId, ActorId>&);
    //static void saveDescriptor(const Descriptor&, QDomElement& );
    //static void readDescriptor(Descriptor*, const QDomElement& );
    static QDomElement saveActor(const Actor*, QDomElement&);
    static QDomElement savePort(const Port*, QDomElement&);
    static Actor* readActor(const QDomElement&);
    static QDomElement saveLink(const Link*, QDomElement&);
    static void saveMeta(const Metadata* meta, QDomElement& proj);
    static QString readMeta(Metadata* meta, const QDomElement& proj);

    static void schema2xml(const Schema& scema, QDomDocument& xml);
    static QString xml2schema(const QDomElement& projectElement, Schema* schema, QMap<ActorId, ActorId>& remapping, bool stopOnErrors = false); 
    static QMap<ActorId, ActorId> deepCopy(const Schema& from, Schema* to);

};

} //namespace Workflow
} //namespace GB2
#endif
