/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_COLLOCATION_SEARCH_ALGORITHM_H_
#define _GB2_COLLOCATION_SEARCH_ALGORITHM_H_

#include <core_api/Task.h>
#include <core_api/LRegion.h>

namespace GB2 {

class CollocationsAlgorithmListener {
public:
    virtual ~CollocationsAlgorithmListener(){};
    virtual void onResult(const LRegion& r) = 0;
};

class CollocationsAlgorithmItem {
public:
    CollocationsAlgorithmItem(){}
    CollocationsAlgorithmItem(const QString& _name) : name(_name){}

    QString         name;
    QList<LRegion> regions;
};

class CollocationsAlgorithmSettings;

class CollocationsAlgorithm {
public:
	enum SearchType {NormalSearch, PartialSearch};
	static void find(const QList<CollocationsAlgorithmItem>& items, TaskStateInfo& si, 
		CollocationsAlgorithmListener* l, const CollocationsAlgorithmSettings& cfg);
private:
    static void findN(const QList<CollocationsAlgorithmItem>& items, TaskStateInfo& si, 
                    CollocationsAlgorithmListener* l, const LRegion& searchRegion, int distance);
	static void findP(const QList<CollocationsAlgorithmItem>& items, TaskStateInfo& si, 
                    CollocationsAlgorithmListener* l, const LRegion& searchRegion, int distance);

};

class CollocationsAlgorithmSettings {
public:
    CollocationsAlgorithmSettings() : st(CollocationsAlgorithm::NormalSearch) {}
    LRegion searchRegion;
    int distance;
    CollocationsAlgorithm::SearchType st;
};


} //namespace GB2
#endif


