/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIOSTRUCT3D_RENDERER_H_
#define _GB2_BIOSTRUCT3D_RENDERER_H_

#include <QtCore/QString>
#include <QtCore/QMap>

namespace GB2 { 

class BioStruct3D;
class BioStruct3DGLRenderer;
class BioStruct3DColorScheme;

//! BioStruct3DGLRenderer abstract factory
class BioStruct3DGLRendererFactory {
public:
    BioStruct3DGLRendererFactory() { }
    virtual ~BioStruct3DGLRendererFactory() { }
    virtual BioStruct3DGLRenderer* createInstance(const BioStruct3D& bs, const BioStruct3DColorScheme* s) = 0;
    static QMap<QString,BioStruct3DGLRendererFactory*> createFactories();
    static const QString defaultFactoryName();
};

#define RENDERER_FACTORY(c) \
public: \
    static const QString ID; \
class Factory : public BioStruct3DGLRendererFactory { \
public: \
    Factory() { } \
    BioStruct3DGLRenderer* createInstance(const BioStruct3D& bs, const BioStruct3DColorScheme* s) { return new c(bs,s); } \
};

//! Abstract biological 3D structure OpenGL renderer
class BioStruct3DGLRenderer {

protected:
	const BioStruct3D& bioStruct;
    const BioStruct3DColorScheme* colorScheme;
    
public:
	BioStruct3DGLRenderer(const BioStruct3D& _bioStruct, const BioStruct3DColorScheme* _s) 
		: bioStruct(_bioStruct), colorScheme(_s) {}

    virtual ~BioStruct3DGLRenderer() { }
    
    virtual void drawBioStruct3D() = 0;

    virtual void updateColorScheme(const BioStruct3DColorScheme* s);
};


} //namespace

#endif // _GB2_BIOSTRUCT3D_RENDERER_H_
