/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <util_ov_annotated_dna/ADVSplitWidget.h>

#include <QtGui/QSplitter>
#include <QtGui/QToolBar>
#include <QtGui/QToolButton>
#include <QtGui/QComboBox>
#include <QtGui/QAction>

namespace GB2 {

class BioStruct3DObject;
class BioStruct3DGLWidget;
class AnnotatedDNAView;
class GObject;
class GObjectView;
class SplitterHeaderWidget;

class BioStruct3DSplitter : public ADVSplitWidget {

    Q_OBJECT
    
public:
    BioStruct3DSplitter(QAction* closeAction, AnnotatedDNAView* view);
    ~BioStruct3DSplitter();
    virtual bool acceptsGObject(GObject* obj);
    BioStruct3DGLWidget* addBioStruct3DGLWidget(BioStruct3DObject* obj);
    BioStruct3DObject* findBioStruct3DObjByName(const QString& objName);
    BioStruct3DObject* findParentBioStruct3DObject();
    virtual void saveState(QVariantMap& m);
    virtual void updateState(const QVariantMap& m);
    QList<BioStruct3DGLWidget*> getChildWidgets();
    BioStruct3DGLWidget* getActiveWidget();
    QAction* getCloseAction() { return closeAction; }
    const QMap<BioStruct3DGLWidget*, QAction*> getShowWidgetActionMap() const;
    const QList<QAction* > getSettingsMenuActions() const;
    QSplitter* getParentSplitter();
    void adaptSize(int numVisibleWidgets);
    void removeWidgetAction(BioStruct3DGLWidget* widget);
	
    virtual QSize sizeHint () const {return QSize(0, 400);}

    void addObject(BioStruct3DObject* obj);
    bool removeObject(BioStruct3DObject* obj);

signals:
    void si_bioStruct3DGLWidgetAdded(BioStruct3DGLWidget* w);

private slots:
    void sl_toggleBioStruct3DWidget(bool show);
    
protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dropEvent(QDropEvent *event);
    bool eventFilter(QObject* o, QEvent* e);

private:
    QMultiMap<BioStruct3DObject*, BioStruct3DGLWidget*> biostrucViewMap;
    QMap<BioStruct3DGLWidget*, QAction*> widgetActionMap;
    QSplitter*  splitter;
    QSplitter*  parentSplitter;
    QAction*    closeAction;
    int         splitterHeight;
	bool		isViewCollapsed;
    
    SplitterHeaderWidget* header;
};


class SplitterHeaderWidget : public QWidget {
    Q_OBJECT

public:
    SplitterHeaderWidget(BioStruct3DSplitter* splitter);
    void updateActions();
    void updateWidgetBox();

public:    
    BioStruct3DSplitter* splitter;
    QToolButton* widgetStateMenuButton;
    QToolButton* settingsMenuButton;
    QToolButton* displayMenuButton;
    QToolButton* restoreDefaultsButton;
    QToolButton* zoomInButton;
    QToolButton* zoomOutButton;
    QComboBox* activeWidgetBox;
    QList<BioStruct3DGLWidget*> widgets;

private slots:
    
    //void sl_removeBioStruct3DGLWidget(BioStruct3DGLWidget* glWidget);
    void sl_addBioStruct3DGLWidget(BioStruct3DGLWidget* glWidget);
    void sl_closeWidget3DGLWidget(BioStruct3DGLWidget* glWidget);
    void sl_showStateMenu();
    void sl_showDisplayMenu();
    void sl_showSettingsMenu();
    void sl_zoomIn();
    void sl_zoomOut();
    void sl_restoreDefaults();

private:
    BioStruct3DGLWidget* getActiveWidget();
	

};



} //namespace
