/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIOSTRUCT3D_TUBE_RENDERER_H_
#define _GB2_BIOSTRUCT3D_TUBE_RENDERER_H_

#include <QtCore/QSharedDataPointer>
#include <QtCore/QVector>
#include <datatype/BioStruct3D.h>

#include "BioStruct3DGLRender.h"


namespace GB2 { 

    class TubeGLRenderer : public BioStruct3DGLRenderer {
        
        QVector< SharedAtom > tubeAtoms; 
        
        void drawTubes(const BioStruct3DColorScheme* colorScheme); 
    public:
        
        TubeGLRenderer(const BioStruct3D& struc, const BioStruct3DColorScheme* s);
        
        void drawBioStruct3D();

        RENDERER_FACTORY(TubeGLRenderer)

    };

} //namespace

#endif // _GB2_BIOSTRUCT3D_TUBE_RENDERER_H_
