/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CHROMATOGRAM_VIEW_H_
#define _GB2_CHROMATOGRAM_VIEW_H_

#include <core_api/GObject.h>
#include <datatype/DNAChromatogram.h>
#include <util_ov_annotated_dna/GSequenceLineView.h>

#include <QtGui>


namespace GB2 {

class ChromatogramViewRenderArea;
class GObjectView;

class ChromatogramView : public GSequenceLineView {
	Q_OBJECT
    friend class ChromatogramViewRenderArea;
public:
	ChromatogramView(QWidget* p, ADVSequenceObjectContext* v, GSequenceLineView* cv, const DNAChromatogram& chroma);

    virtual void buildPopupMenu(QMenu& m);

    virtual bool isWidgetOnlyObject(GObject* o) const;

    DNASequenceObject* getEditedSequence() const {return editDNASeq;}

protected:
	virtual void pack();
	void mousePressEvent(QMouseEvent* me);

private slots:
	void setRenderAreaHeight(int k);
	void sl_minusButtonClicked();
	void sl_plusButtonClicked();
	void sl_onPopupMenuCkicked(QAction* a);
	void sl_addNewSequenceObject();
	void sl_onAddExistingSequenceObject();
	void sl_clearEditableSequence();
	void sl_removeChanges();

	
    void sl_onObjectRemoved(GObjectView*, GObject*);


private:
    bool checkObject(GObject* obj);

    DNASequenceObject*			editDNASeq;
    QList<int>					indexOfChangedChars;

    QSlider*					scaleBar;
	QToolButton*				minusButton;
	QToolButton*				plusButton;
	ChromatogramViewRenderArea* ra;
	QMenu*						mP;
	int							selIndex;
	QAction*					addNewSeqAction;
	QAction*					addExistSeqAction;
	QAction*					clearEditableSequence;
	QAction*					removeChanges;
};


class ChromatogramViewRenderArea : public GSequenceLineViewRenderArea {
    Q_OBJECT
public:
	ChromatogramViewRenderArea(ChromatogramView* p, const DNAChromatogram& chroma);
	~ChromatogramViewRenderArea();

    int getHeightAreaBC() const {return heightAreaBC;}
	void setAreaHeight(int newH);
	virtual int coordToPos(int x) const;
	virtual int posToCoord(int p, bool useVirtualSpace = false) const;
	QRectF posToRect(int p) const;
	QRectF				selRect;
	bool				hasSel;
	qreal				charWidth;
	qreal				charHeight;
	qreal				addUpIfQVL;
	

protected:
	virtual void drawAll(QPaintDevice* pd);

private:
	void drawChromatogramTrace(qreal x, qreal y, qreal w, qreal h, QPainter& p, const LRegion& visible);
	void drawOriginalBaseCalls(qreal x, qreal y, qreal w, qreal h, QPainter& p, const LRegion& visible, const QByteArray& ba, bool is = true);
	void drawQualityValues(qreal x, qreal y, qreal w, qreal h, QPainter& p, const LRegion& visible, const QByteArray& ba);
	void drawChromatogramBaseCallsLines(qreal x, qreal y, qreal w, qreal h, QPainter& p, const LRegion& visible, const QByteArray& ba);

	DNAChromatogram chroma;
	int				chromaMax;
	QPen			linePen;
	QFont			font;
	QFont			fontBold;
	int				heightPD;
	int				heightAreaBC;
	int				areaHeight;
	qreal			kLinearTransformTrace;
	qreal			bLinearTransformTrace;
	qreal			kLinearTransformBaseCallsOfEdited;
	qreal			bLinearTransformBaseCallsOfEdited;
	float			k;
	float			b;
	qreal			xBaseCallsOfEdited;
	qreal			yBaseCallsOfEdited;
	qreal			wBaseCallsOfEdited;
	qreal			hBaseCallsOfEdited;
	bool			heightChanged;

private:
	int				lineHeight;
	int				yCharOffset;
	int				xCharOffset;

	
	int				lm;
	int				rm;
};


} // namespace


#endif
