/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SEND_SELECTION_DIALOG_IMPL_H_
#define _GB2_SEND_SELECTION_DIALOG_IMPL_H_

#include <ui/ui_SendSelectionDialog.h>
#include <util_gui/CreateAnnotationWidgetController.h>
#include "RemoteRequestPlugin.h"

namespace GB2
{

class SendSelectionDialogImpl : public QDialog,  Ui_SendSelectionDialog
{
    Q_OBJECT
public:
    SendSelectionDialogImpl( QList<Script *> _scripts, const GObjectReference& seqRef, bool _isAminoSeq );
    QString getGroupName() const {return ca_m.groupName;}
    AnnotationTableObject* getAnnotationObject() const {return ca_m.annotationObject;}
private slots:
    void sl_scriptSelected( int index );
    void sl_customSettings();
    void sl_minResLenChanged( int i );
    void sl_maxResLenChanged( int i );
    void sl_OK();

private:
    void setupScriptsList();
    void setupAlphabet();
    void setupStrand();

public:
    int maxResultLen;
    int minResultLen;
    int maxQueryLen;
    SendSelectionStrand strand;
    SendSelectionAlphabet alpha;
    Script * chosen;

private:

    QList< Script * > scripts;
    bool isAminoSeq;
    CreateAnnotationModel ca_m;
    CreateAnnotationWidgetController * ca_c;
    QScriptEngine engine;
    bool extImported;
};

} //namespace

#endif
