/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "RepeatFinder.h"
#include "RepeatFinderDiagonal.h"
#include "RepeatFinderSArray.h"
#include "RepeatFinderSArrayWK.h"

#include <assert.h>

namespace GB2 {

RepeatFinder::RepeatFinder(const char* _seqx, quint32 _sizex, const char* _seqy, quint32 _sizey,
                         DNAAlphabet* _al, quint32 _w, quint32 _k)
: seqX(_seqx), seqY(_seqy), SIZE_X(_sizex), SIZE_Y(_sizey), al(_al),
WINDOW_SIZE(_w), K(_k), C(_w-_k), HALF_WINDOW_SIZE_L(_w / 2), HALF_WINDOW_SIZE_H ((_w / 2) + (_w % 2))

{
    resultsListener = NULL;
    reflective = seqX == seqY && SIZE_X==SIZE_Y;
    unknownChar = al->getDefaultSymbol();
}

RepeatFinder* RepeatFinder::newInstance(  const char *seqX, quint32 sizeX, 
                                        const char *seqY, quint32 sizeY, 
                                        DNAAlphabet* al, quint32 w, quint32 mismatches,  quint32 nThreads)
{
    assert(mismatches < w);
	qDebug("new calc: sizex=%d, sizey=%d, seqtype=%d, w=%d, mismatches=%d, threads=%d", sizeX, sizeY, al->getType(), w, mismatches, nThreads);
    if (mismatches == 0) {
		//return new DotPlotCalcDiagonalW(seqX, seqY, w, diagRange, nThreads);
		return new RepeatFinderSArrayW(seqX, sizeX, seqY, sizeY, al, w,  nThreads);
	}
    int matches = w-mismatches;
	bool suffix = FALSE;
	int q = w/(matches+1);
	if (q>=4 || (q==3 && (al->getType() == DNAAlphabet_AMINO || al->getType() == DNAAlphabet_RAW))) {
		suffix = TRUE;
	}
//	qDebug("use suffix %d\n", suffix);
	bool ok = 1;
	if (ok && suffix) {
		return new RepeatFinderSArrayWK(seqX, sizeX, seqY, sizeY, al, w, mismatches, nThreads);
	} else {
		return new RepeatFinderDiagonalWK(seqX, sizeX, seqY, sizeY, al, w, matches, nThreads);
	}
}

}//namespace						 
