/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TEST_VIEW_CONTROLLER_H_
#define _GB2_TEST_VIEW_CONTROLLER_H_

#include <core_api/MainWindow.h>
#include <ui/ui_TestView.h>

#include <QtGui/QTreeWidgetItem>

namespace GB2 {

#define ULOG_CAT_PLUGIN_TEST_RUNNER "Plugin: Test Runner"

class GTestSuite;
class GTestRef;
class GTestState;
class TVTSItem;
class TVTestItem;
class TVItem;
class TestRunnerService;
class TestRunnerTask;
class TestViewReporter;

class TestViewController : public MWMDIWindow, Ui::TestView {
    Q_OBJECT
public:
    TestViewController(TestRunnerService* s);

    virtual void setupMDIToolbar(QToolBar* tb);
    virtual void setupViewMenu(QMenu* n);
    
    void killAllChildForms();
    void reporterFormClosedOutside(){reporterForm=NULL;}
    
private slots:

    void sl_treeCustomContextMenuRequested(const QPoint & pos);
    void sl_treeItemSelectionChanged();
    void sl_treeDoubleClicked(QTreeWidgetItem*, int);

    void sl_suiteAdded(GTestSuite* ts);
    void sl_suiteRemoved(GTestSuite* ts);

    void sl_addTestSuiteAction();
    void sl_removeTestSuiteAction();
    void sl_runAllSuitesAction();
    void sl_runSelectedSuitesAction();
    void sl_stopSuitesActions();
    void sl_setEnvAction();
    void sl_report();
    void sl_testStateChanged(GTestState*);
    void sl_taskStateChanged(Task* t);


protected:
    virtual bool onCloseEvent();

private:
    void updateState();
    
    void createAndRunTask(const QList<GTestState*>& testsToRun);
    QList<TVTSItem*> getSelectedSuiteItems() const;
    QList<TVTestItem*> getSelectedTestItems() const;
    
    void addTestSuite(GTestSuite* ts);
    void addFolderTests(TVTSItem* tsi, GTestRef* testRef,const QString* curPath);
    void addTest(TVTSItem* tsi, GTestRef* t);
    TVTSItem* findTestSuiteItem(GTestSuite* ts) const;
    TVTestItem* findTestViewItem(GTestRef* tr) const;
    TVTestItem* findTestViewItemRecursive(GTestRef* testRef,TVItem* sItem) const;
    TVTSItem* getFolder(TVItem* element,const QString* folderName)const;

    QList<GTestState*> getSubTestToRun(TVItem* sItem,bool runAll)const;
    bool  allSuitesIsInRoot(const QList<TVTSItem*> suitesList) const;

    TestRunnerService* service;

    QAction* addTestSuiteAction;
    QAction* removeTestSuiteAction;
    QAction* runAllSuitesAction;
    QAction* runSelectedSuitesAction;
    QAction* stopSuitesActions;
    QAction* setEnvAction;
    QAction* report;

    TestRunnerTask* task;
    TestViewReporter* reporterForm; 
    QTime* startRunTime ;
    QTime* endRunTime;
    int time;
};

enum TVItemType {
    TVItem_TestSuite,
    TVItem_Test,
};

class TVItem : public QTreeWidgetItem {
public:
    TVItem(TVItemType t) : type(t) {}
    
    virtual void updateVisual() = 0;

    virtual QString getRichDesc() const = 0;

    const TVItemType type;
    
    bool isSuite() const {return type == TVItem_TestSuite;}
    
    bool isTest() const {return type == TVItem_Test;}

};

class TVTSItem : public  TVItem {
public:
    TVTSItem(GTestSuite* ts);

    TVTSItem(const QString& _name);

    
    virtual void updateVisual();
    
    virtual QString getRichDesc() const;

    GTestSuite* ts;

    QString name;

    QString getUrl() const;

    void getTestsState(int *passed,int *failed,int *none);

};

class TVTestItem : public  TVItem {
public:
    TVTestItem(GTestState* testState);

    virtual void updateVisual();

    virtual QString getRichDesc() const;

    GTestState* testState;
};

}//namespace

#endif

