/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "WorkflowDesignerPlugin.h"
#include "WorkflowViewController.h"
#include "WorkflowDocument.h"

#include "library/CoreLib.h"

#include <workflow/WorkflowEnv.h>

#include <core_api/AppContext.h>
#include <core_api/MainWindow.h>
#include <core_api/Log.h>
#include <core_api/Settings.h>
#include <core_api/Task.h>

#include <QtGui/QMenu>

/* TRANSLATOR GB2::LocalWorkflow::WorkflowView */
/* TRANSLATOR GB2::LocalWorkflow::WorkflowDesignerPlugin */

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    WorkflowDesignerPlugin * plug = new WorkflowDesignerPlugin();
	return plug;
}

static LogCategory log(ULOG_CAT_WD);

#define PLUGIN_SETTINGS QString("workflowview/")


WorkflowDesignerPlugin::WorkflowDesignerPlugin() 
: Plugin(tr("Workflow Designer"), tr("Workflow Designer allows to create complex computational workflows."))
{
    services << new WorkflowDesignerService(this);
}

class CloseDesignerTask : public Task {
public:
    CloseDesignerTask(WorkflowDesignerService* s) : 
      Task(GB2::WorkflowDesignerPlugin::tr("Close Designer"), TaskFlags_NR_DWF),
          service(s) {}
    virtual void prepare();
private:
    WorkflowDesignerService* service;
};

void CloseDesignerTask::prepare() {
    if (!service->closeViews()) {
        stateInfo.error = GB2::WorkflowDesignerPlugin::tr("Close Designer canceled");
    }
}

Task* WorkflowDesignerService::createServiceDisablingTask(){
    return new CloseDesignerTask(this);
}

WorkflowDesignerService::WorkflowDesignerService(Plugin* p) 
: Service(p, 123, p->getName(), ""),
designerAction(NULL), managerAction(NULL)
{
    Workflow::CoreLib::init();
    df = new WorkflowDocFormat(this);
    vf = new WorkflowViewFactory(this);
}

void WorkflowDesignerService::serviceStateChangedCallback(ServiceState , bool enabledStateChanged) {

    if (!enabledStateChanged) {
        return;
    }
    if (isEnabled()) {
        AppContext::getDocumentFormatRegistry()->registerFormat(df);
        AppContext::getObjectViewFactoryRegistry()->registerGObjectViewFactory(vf);
        assert(designerAction == NULL);

        designerAction = new QAction(getName(), this);
        connect(designerAction, SIGNAL(triggered()), SLOT(sl_showDesignerWindow()));

        //managerAction = new QAction(tr("Workflow Manager"), this);
        //connect(designerAction, SIGNAL(triggered()), SLOT(sl_showManagerWindow()));

        AppContext::getMainWindow()->getMenuManager()->getTopLevelMenu(MWMENU_TOOLS)->addAction(designerAction);
        //AppContext::getMainWindow()->getMenuManager()->getTopLevelMenu(MWMENU_TOOLS)->addAction(managerAction);

        //FIXME refactor
        if (AppContext::getSettings()->getValue(PLUGIN_SETTINGS + "isVisible", false).toBool()) {
            sl_showDesignerWindow();
        }
    } else {
        delete designerAction;
        designerAction = NULL;
        AppContext::getDocumentFormatRegistry()->unregisterFormat(df);
        AppContext::getObjectViewFactoryRegistry()->unregisterGObjectViewFactory(vf);
    }
}

bool WorkflowDesignerService::closeViews() {
    MWMDIManager* wm = AppContext::getMainWindow()->getMDIManager();
    assert(wm);
    foreach(MWMDIWindow* w, wm->getWindows()) {
        WorkflowView* view = qobject_cast<WorkflowView*>(w);
        if (view) {
            if (!AppContext::getMainWindow()->getMDIManager()->closeMDIWindow(view)) {
                return false;
            }
        }
    }
    return true;
}

void WorkflowDesignerService::sl_showDesignerWindow() {
    assert(isEnabled());
    WorkflowView* view = new WorkflowView(NULL); //FIXME
    AppContext::getMainWindow()->getMDIManager()->addMDIWindow(view);
    AppContext::getMainWindow()->getMDIManager()->activateWindow(view);
}

void WorkflowDesignerService::sl_showManagerWindow() {

}

}//namespace
