/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DocActors.h"
#include "CoreLib.h"

#include <workflow_support/CoreDataTypes.h>
#include <workflow_support/DelegateEditors.h>
#include <workflow_library/BioDatatypes.h>
#include <workflow_library/BioActorLibrary.h>
#include <core_api/DocumentModel.h>
#include <util_gui/DialogUtils.h>

namespace GB2 {
namespace Workflow {

DocActorProto::DocActorProto(const DocumentFormatId& fid, bool multi,
                             const Descriptor& desc, 
                             const QList<PortDescriptor*>& ports, 
                             const QList<Attribute*>& _attrs) : 
BusActorPrototype(desc, ports, _attrs), fid(fid) 
{
    attrs << new Attribute(CoreLib::URL_ATTR(), CoreDataTypes::STRING_TYPE(), multi);
    setEditor(new DelegateEditor(CoreLib::URL_ATTR_ID, 
        new URLDelegate(DialogUtils::prepareDocumentsFileFilter(fid, true), QString(), multi)));
    if (!multi) {
        setValidator(new ScreenedParamValidator(CoreLib::URL_ATTR_ID, ports.first()->getId(), CoreLib::URL_SLOT_ID));
    }
}

bool DocActorProto::isAcceptableDrop(const QMimeData* md, QVariantMap* params) const {
    QList<DocumentFormat*> fs;
    QString url = DesignerUtils::getDropUrl(fs, md);
    foreach(DocumentFormat* df, fs) {
        if (fid == df->getFormatId()) {
            if (params) {
                params->insert(CoreLib::URL_ATTR_ID, url);
            }
            return true;
        }
    }

    return false;
}

QString WriteGenbankPrompter::composeRichDoc() {
    BusPort* input = qobject_cast<BusPort*>(target->getPort(CoreLib::DATA_PORT_ID));

    Actor* seqProducer = input->getProducer(BioActorLibrary::SEQ_SLOT_ID);
    QString seqName = seqProducer ? tr(" sequence from <u>%1</u>").arg(seqProducer->getLabel()) : "";
    QString annName = getProducers(CoreLib::DATA_PORT_ID, BioActorLibrary::FEATURE_TABLE_SLOT_ID);
    if (!annName.isEmpty()) {
        annName = tr(" set of annotations from <u>%1</u>").arg(annName);
    }

    QString url = getURL(CoreLib::URL_ATTR_ID);
    QString data;
    if (seqName.isEmpty() && annName.isEmpty()) {
        return url;
    } else if (!seqName.isEmpty() && !annName.isEmpty()) {
        data = tr("For each %1 and %2").arg(seqName).arg(annName);
    } else {
        data = tr("For each ") + seqName + annName;
    }

    QString extra;
    //     Actor* acnProducer = input->getProducer(CoreLib::GENBANK_ACN_SLOT.getId());
    //     if (!acnProducer) {
    //         extra = tr("<br>Autogenerate ACN.");
    //     }

    QString doc = tr("%1, add Genbank entry to document <u>%2</u>.%3")
        .arg(data) //sequence from Read Fasta 1
        .arg(url) 
        .arg(extra);

    return doc;
}

QString WriteFastaPrompter::composeRichDoc() {
    BusPort* input = qobject_cast<BusPort*>(target->getPort(CoreLib::DATA_PORT_ID));
    QString url = getURL(CoreLib::URL_ATTR_ID);

    Actor* seqProducer = input->getProducer(BioActorLibrary::SEQ_SLOT_ID);
    if (!seqProducer) {
        return url;
    }

    QString doc = tr("For each sequence from <u>%1</u>, add entry to document <u>%2</u>.")
        .arg(seqProducer->getLabel())
        .arg(url);

    return doc;
}

QString WriteDocPrompter::composeRichDoc() {
    BusPort* input = qobject_cast<BusPort*>(target->getPort(CoreLib::DATA_PORT_ID));
    QString url = getURL(CoreLib::URL_ATTR_ID);
    QString producers = getProducers(CoreLib::DATA_PORT_ID, slot);
    if (producers.isEmpty()) {
        return url;
    }
    return spec.arg(producers).arg(url);
}

QString ReadDocPrompter::composeRichDoc() {
    return spec.arg(getURL(CoreLib::URL_ATTR_ID));
}
}//namespace Workflow
}//namespace GB2
