/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_READ_SEQ_WORKER_H_
#define _GB2_WORKFLOW_READ_SEQ_WORKER_H_

#include <workflow_library/LocalDomain.h>
#include <datatype/DNASequence.h>
#include <datatype/MAlignment.h>

namespace GB2 {
namespace LocalWorkflow {

class LoadSeqTask : public Task {
    Q_OBJECT
public:
    LoadSeqTask(QString url, const QVariantMap& cfg) 
        : Task(tr("Read sequences from %1").arg(url), TaskFlag_DeleteWhenFinished),
        url(url), cfg(cfg) {}
    virtual void run();

    QString url;
    QVariantMap cfg;
    QList<DNASequence> results;
};

class LoadMSATask : public Task {
    Q_OBJECT
public:
    LoadMSATask(QString url) : Task(tr("Read MSA from %1").arg(url), TaskFlag_DeleteWhenFinished), url(url) {}
    virtual void run();

    QString url;
    QList<MAlignment> results;
};


class GenericMSAReader : public BaseWorker {
    Q_OBJECT
public:
    GenericMSAReader(Actor* a) : BaseWorker(a), ch(NULL), done(false) {}
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() {}

protected slots:
    virtual void sl_taskFinished();

protected:
    virtual Task* createReadTask(const QString& url) {return new LoadMSATask(url);}
    CommunicationChannel* ch;
    QList<QString> urls;
    bool done;
    QList<Message> cache;
    DataTypePtr mtype;
};

class GenericSeqReader : public GenericMSAReader {
    Q_OBJECT
public:
    GenericSeqReader(Actor* a) : GenericMSAReader(a){}
    virtual void init() ;

protected slots:
    virtual void sl_taskFinished();

protected:
    virtual Task* createReadTask(const QString& url) {return new LoadSeqTask(url, cfg);}
    QVariantMap cfg;
};


}//Workflow namespace
}//GB2 namespace

#endif
