/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SITECON_ALG_H_
#define _GB2_SITECON_ALG_H_

#include <core_api/LRegion.h>
#include <core_api/Task.h>

#include <QtCore/QVector>

#define ULOG_CAT_SITECON "Plugin: SITECON"

namespace GB2 {

class MAlignment;
class DiProperty;

//average and deviation for one property
class DiStat {
public:
    DiStat(DiProperty* p, float d, float a): prop(p), sdeviation(d), average(a), weighted(false){}
    DiStat(): prop(NULL), sdeviation(-1), average(-1), weighted(false){}

    DiProperty* prop;
    float       sdeviation;
    float       average;
    bool        weighted;
};
typedef QVector<DiStat> PositionStats;

enum SiteconWeightAlg {
    SiteconWeightAlg_None,
    SiteconWeightAlg_Alg2
};

class SiteconBuildSettings {
public:
    SiteconBuildSettings() : windowSize(0), randomSeed(0), secondTypeErrorCalibrationLen(100*1000), 
        chisquare(0.95),numSequencesInAlignment(0), weightAlg(SiteconWeightAlg_None)
    {
        acgtContent[0] = acgtContent[1] = acgtContent[2] = acgtContent[3] = 25;
    }

    int                 windowSize;
    int                 randomSeed;
    int                 secondTypeErrorCalibrationLen;
    float               chisquare;
    int                 numSequencesInAlignment;
    SiteconWeightAlg    weightAlg;
    int                 acgtContent[4];
    QList<DiProperty*>  props;
};


class SiteconModel {
public:
    SiteconModel(){ deviationThresh = -1;}
    QString                 modelFileName;
    SiteconBuildSettings    settings;
    QVector<PositionStats>  matrix;
    QVector<float>          err1;
    QVector<float>          err2;
    float                   deviationThresh;
    bool checkState(bool doAssert = true) const;
};

class DNATranslation;
class SiteconAlgorithm : public QObject {
    Q_OBJECT
public:
    static QVector<PositionStats> calculateDispersionAndAverage(const MAlignment& ma, const SiteconBuildSettings& s, TaskStateInfo& ts);

    static float calculatePSum(const char* seq, int len, const QVector<PositionStats>& normalizedMatrix, 
                               const SiteconBuildSettings& settings, float devThreshold, DNATranslation* complMap = NULL);
        
    static QVector<float> calculateFirstTypeError(const MAlignment& ma, const SiteconBuildSettings& s, TaskStateInfo& ts);

    static QVector<float> calculateSecondTypeError(const QVector<PositionStats>& matrix, const SiteconBuildSettings& s, TaskStateInfo& ts);

    static QVector<PositionStats> normalize(const QVector<PositionStats>& matrix, const SiteconBuildSettings& s);

    static int calculateWeights(const MAlignment& ma, QVector<PositionStats>& matrix, 
                                const SiteconBuildSettings& settings, bool matrixIsNormalized, TaskStateInfo& s);

    static void calculateACGTContent(const MAlignment& ma, SiteconBuildSettings& bs);

    static QByteArray generateRandomSequence(const int* actgContent, int seqLen, TaskStateInfo& ts);
};

}//namespace

#endif
