/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SETTINGS_IMPL
#define _GB2_SETTINGS_IMPL

#include <QtCore/QSettings>

#include <core_api/Settings.h>

namespace GB2 {

//TODO: mutex!

class SettingsImpl : public Settings
{
public:
    SettingsImpl(QSettings::Scope scope);
    
    QStringList getAllKeys(const QString& path);

    virtual bool contains(const QString& key) const;
    virtual void remove(const QString& key);

    virtual QVariant getValue(const QString& key, const QVariant& defaultValue = QVariant()) const;
    virtual void setValue(const QString& key, const QVariant& value);

    virtual void sync() {settings.sync();}

private:
    QString preparePath(const QString& pathName) const ;
    
    QSettings settings;
};
}//namespace
#endif
