/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "LogCache.h"

#ifdef Q_OS_WIN32
#include "windows.h"
#endif

#define MAX_CACHE_SIZE 5000

namespace GB2 {

//////////////////////////////////////////////////////////////////////////
///cache
LogCache::LogCache() {
    connect(LogServer::getInstance(), SIGNAL(si_message(const LogMessage&)), SLOT(sl_onMessage(const LogMessage&)));
}

LogCache::~LogCache() {
    while (!messages.empty()) {
        LogMessage* m = messages.takeFirst();
        delete m;
    }
}

void LogCache::sl_onMessage(const LogMessage& msg) {
    messages.append(new LogMessage(msg.category, msg.level, msg.text));

#ifdef _DEBUG
    QByteArray ba = msg.text.toLocal8Bit();
    char* buf = ba.data();
#ifdef Q_OS_WIN32
    // a bit of magic to workaround Windows console encoding issues
    CharToOemA(buf,buf);
#endif
    printf("%s\n", buf);
#endif
    updateSize();
}

void LogCache::updateSize() {
    while (messages.size() > MAX_CACHE_SIZE) {
        LogMessage* m = messages.takeFirst();
        delete m;
    }
}

}//namespace

