/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PLUGINSUPPORT_IMPL_
#define _GB2_PLUGINSUPPORT_IMPL_

#include <core_api/PluginModel.h>
#include <core_api/Task.h>

#include <QtCore/QLibrary>
#include <QtCore/QDir>

namespace GB2 {

class ServiceRegistryImpl;
class AddPluginTask;
class RemovePluginTask;

class PluginRef {
public:
	PluginRef(Plugin* _plugin, QLibrary* _library, const QString& url);
    static QString getPluginId(const QString& url);

    ~PluginRef();

	Plugin*		plugin;
    QLibrary*	library;
    QString     url;
    QString     pluginId;
    bool        removeFlag;
};

class PluginSupportImpl : public PluginSupport {
    Q_OBJECT

	friend class AddPluginTask;
	
public:
	PluginSupportImpl(Plugin* corePlugin);
	~PluginSupportImpl();

	virtual const QList<Plugin*>& getPlugins() {return plugins;}

	virtual ServiceRegistry* getServiceRegistry() const;

	virtual Task* addPluginTask(const QString& pathToPlugin);

    //plugin will not be removed from the plugin list during the next app run
    virtual void setRemoveFlag(Plugin* p, bool v);
    virtual bool getRemoveFlag(Plugin* p) const;


    static bool isDefaultPluginsDir(const QString& url);
    static QDir getDefaultPluginsDir();

    PluginRef* findRef(Plugin* p) const;
    PluginRef* findRefById(const QString& pluginId) const;
    PluginRef* findRefByURL(const QString& url) const;

protected:
	void registerPlugin(PluginRef* ref); 
	void unregisterPlugin(Plugin* p); 
    QString getPluginFileURL(Plugin* p) const;
    
    void updateSavedState(PluginRef* ref);

private:
    ServiceRegistryImpl* serviceRegistry;
    QList<PluginRef*>	plugRefs;
    QList<Plugin*>		plugins;
};


class AddPluginTask : public Task {
    Q_OBJECT
public:
	AddPluginTask(PluginSupportImpl* ps, const QString& url);
	ReportResult report();
	

private:
	PluginSupportImpl*  ps;
	QString             url;
};


}//namespace

#endif 
