/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROJECT_SERVICE_IMPL_H_
#define _GB2_PROJECT_SERVICE_IMPL_H_

#include <core_api/ProjectModel.h>
#include <core_api/Task.h>

#include <QtGui/QAction>

namespace GB2 {

class ProjectServiceImpl : public ProjectService {
    Q_OBJECT

    friend class ProjectServiceEnableTask;
	friend class ProjectServiceDisableTask;
public:
	ProjectServiceImpl(Plugin* p, Project* pr); 
	~ProjectServiceImpl();

	virtual Project* getProject() const {return pr;}

	virtual Task* saveProjectTask(SaveProjectTaskKind k);

	virtual Task* closeProjectTask();

protected:
	virtual Task* createServiceEnablingTask();
	virtual Task* createServiceDisablingTask();

private slots:
	void sl_save();
    void sl_saveAs();
	void sl_closeProject();
	
private:
	QAction* saveAction;
    QAction* saveAsAction;
	QAction* closeProjectAction;

	Project* pr;
};


//////////////////////////////////////////////////////////////////////////
/// Tasks
class ProjectServiceEnableTask : public Task {
    Q_OBJECT
public:
	ProjectServiceEnableTask(ProjectServiceImpl* psi);
	virtual ReportResult report();
private:
	ProjectServiceImpl* psi;
};


class ProjectServiceDisableTask : public Task {
    Q_OBJECT
public:
	ProjectServiceDisableTask(ProjectServiceImpl* psi);
	virtual ReportResult report();
private:
	ProjectServiceImpl* psi;
};

}//namespace

#endif

