/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ProjectViewDocTree.h"

#include <core_api/GObject.h>
#include <core_api/DocumentModel.h>
#include <util_gui/ProjectTreeController.h>

namespace GB2 {

ProjectViewDocTree::ProjectViewDocTree(QWidget* w) : QTreeWidget(w) 
{
    setDragDropMode(QAbstractItemView::DragDrop);
}

QMimeData * ProjectViewDocTree::mimeData( const QList<QTreeWidgetItem *> items ) const {
    if (items.size() != 1) {
        return NULL;
    }
    QMimeData * mime = NULL;
    ProjViewTreeItem* item = (ProjViewTreeItem*)items.first();
    if (item->isObjectItem()) {
        ProjViewObjectTreeItem* objItem = (ProjViewObjectTreeItem*)item;
        mime = new GObjectMimeData(objItem->obj);
    } else if (item->isDocumentItem()) {
        mime = new DocumentMimeData(static_cast<ProjViewDocumentTreeItem*>(item)->doc);

    }
    return mime;
}


}//namespace
