/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TASK_SCHEDULER_IMPL_H_
#define _GB2_TASK_SCHEDULER_IMPL_H_

#include <core_api/Task.h>

#include <QtCore/QThread>
#include <QtCore/QTimer>

namespace GB2 {

class TaskInfo;

class TaskThread : public QThread {
public:
	TaskThread(TaskInfo* _ti) : ti(_ti) {}
	void run();

	TaskInfo* ti;
};


class TaskInfo {
public:
	TaskInfo(Task* t, TaskInfo* p) 
		: task (t), parentTaskInfo(p), runFinished(false), wasPrepared(false), prevProgress(0), 
		numRunningSubtasks(0), numFinishedSubtasks(0),  thread(NULL) {}
    
    virtual ~TaskInfo() {
        delete thread;
    }

	Task*			task;
	TaskInfo*		parentTaskInfo;
	QList<Task*>	newSubtasks;
	bool			runFinished;
    bool            wasPrepared;


	int				prevProgress;	//used for TaskProgress_Manual
    QString         prevDesc;

	int				numRunningSubtasks;
	int				numFinishedSubtasks;

	TaskThread*		thread;


};

class TaskSchedulerImpl : public TaskScheduler {
	Q_OBJECT
public:
	TaskSchedulerImpl();
	~TaskSchedulerImpl();

	virtual void registerTopLevelTask(Task* t);

	virtual void unregisterTopLevelTask(Task* t);

	const QList<Task*>& getTopLevelTasks() const {return topLevelTasks;}

	QDateTime estimatedFinishTime(Task*) const;
	
	virtual void cancelTask(Task* t);
	
	virtual void cancelAllTasks();
	
	virtual QString getStateName(Task* t) const;

private slots:
	void update();
	bool processFinishedTasks();
	void unregisterFinishedTopLevelTasks();
	void processNewSubtasks();
	void prepareNewTasks();
	void runReady();

private:
	bool readyToFinish(TaskInfo* ti);
	void addToPriorityQueue(Task* t, TaskInfo* parentInfo);
	void runTask(TaskInfo* pi);
	void stopTask(Task* t);
	void updateTaskProgressAndDesc(TaskInfo* ti);
	void promoteTask(TaskInfo* ti, Task::State newState);
	void deleteTask(Task* t);

private:
	QTimer					timer;
	QList<Task*>			topLevelTasks;
	QList<TaskInfo*>		priorityQueue;
	QList<TaskInfo*>		tasksWithNewSubtasks;
	QList<Task*>			newTasks;
    QStringList             stateNames;

};

} //namespace
#endif
