##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

include( src/ugene_globals.pri )

TEMPLATE = subdirs debug_and_release
CONFIG += ordered
!unix {
    SUBDIRS = src/libs_3rdparty/zlib
}
SUBDIRS += src/libs_3rdparty/qtbindings_core \
          src/libs_3rdparty/qtbindings_gui \
          src/libs_3rdparty/qtbindings_xml \
          src/core \
          src/ugene \
          src/plugins_3rdparty/sitecon \
          src/plugins_3rdparty/umuscle \
          src/plugins_3rdparty/uhmmer \
          src/plugins/biostruct3d_view \
          src/plugins/chroma_view \
          src/plugins/annotator \
          src/plugins/dna_export \
          src/plugins/dna_graphpack \
          src/plugins/orf_marker \
          src/plugins/workflow_designer \
          src/plugins/repeat_finder \
          src/plugins/remote_request \
          src/plugins/test_runner

unix {
    system( cd src && mkdir _debug )
    system( cd src && mkdir _release )
    system( chmod a+x ./src/gen_bin_script.cmd && ./src/gen_bin_script.cmd $$UGENE_INSTALL_DIR > ugene; chmod a+x ugene )
    binscript.files += ugene
    binscript.path = $$UGENE_INSTALL_BINDIR

    system( cd src && chmod a+x qtranslate.cmd && ./qtranslate.cmd )
    transl.files = ./src/_release/transl_en.qm ./src/_release/transl_ru.qm
    transl.path = $$UGENE_INSTALL_DIR

    scripts.files += scripts/*
    scripts.path = $$UGENE_INSTALL_DIR/scripts

    app_data.files += data/DBXRefRegistry.txt \
                      data/translations.txt \
                      data/weight_matrix/*
    app_data.path = $$UGENE_INSTALL_DIR/data
                                                    
    data.files += data/sitecon_models data/samples
    data.path = $$UGENE_INSTALL_DATA
                                                                
    desktop.files += installer/_common_data/ugene.desktop
    desktop.path = $$UGENE_INSTALL_DESKTOP
    
    icons.files += installer/_common_data/ugene.png installer/_common_data/ugene.xpm
    icons.path = $$UGENE_INSTALL_PIXMAPS
    
    manual.files += installer/_common_data/ugene.1.gz
    manual.path = $$UGENE_INSTALL_MAN
    
    INSTALLS += binscript transl scripts app_data data desktop icons manual
}
