/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <core_services/AppContextImpl.h>
#include <core_services/SettingsImpl.h>
#include <core_services/DocumentFormatRegistryImpl.h>
#include <core_services/IOAdapterRegistryImpl.h>

#include <plugin_support/PluginSupportImpl.h>
#include <plugin_support/ServiceRegistryImpl.h>
#include <task_scheduler/TaskSchedulerImpl.h>
#include <core_services/AppSettingsImpl.h>

#include <core_api/AppGlobals.h>
#include <core_api/Log.h>
#include <core_api/Timer.h>
#include <core_api/DNATranslation.h>
#include <core_api/ObjectViewModel.h>
#include <core_api/ResourceTracker.h>
#include <core_api/DocumentFormatConfigurators.h>
#include <core_api/ScriptRegistry.h>
#include <core_api/DBXRefRegistry.h>
#include <core_api/UserApplicationsSettings.h>
#include <core_api/SecStructPredictAlgRegistry.h>
#include <core_api/CudaGpuRegistry.h>
#include <script/GScriptRunner.h>
#include <script/GScriptModuleRegistry.h>

#include <core_api/SubstMatrixRegistry.h>
#include <core_api/SWResultFilterRegistry.h>
#include <core_api/SmithWatermanTaskFactoryRegistry.h>
#include <molecular_geometry/MolecularSurfaceFactoryRegistry.h>

#include <document_format/DNAAlphabetRegistryImpl.h>
#include <gobjects/AnnotationSettings.h>
#include <gobjects/GObjectTypes.h>
#include <test_framework/GTestFrameworkComponents.h>
#include <test_framework/TestRunnerTask.h>
#include <util_gui/BaseDocumentFormatConfigurators.h>
#include <util_ov_msaedit/MSAColorScheme.h>

#include <workflow_support/WorkflowEnvImpl.h>
#include <workflow_library/BioActorLibrary.h>

#include <util_tasks/TaskStarter.h>
#include <util_index_support/UIndexSupport.h>

#include "ProjectLoaderImpl.h"
#include "LogDriver.h"
#include "ShutdownTask.h"
#include "TestStarter.h"
#include "WorkflowStarter.h"
#include "TaskStatusBar.h"

#include <QtCore/QCoreApplication>

static GB2::LogCategory logCat(ULOG_CAT_USER_INTERFACE);
#define LOG_SETTINGS_ROOT QString("log_settings/")
#define TR_SETTINGS_ROOT QString("test_runner/")

/* TRANSLATOR GB2::AppContextImpl */

namespace GB2 {

static void registerCoreServices() {
    ServiceRegistry* sr = AppContext::getServiceRegistry();
    TaskScheduler* ts = AppContext::getTaskScheduler();
    //ts->registerTopLevelTask(sr->registerServiceTask(new PluginViewerImpl()));
    //ts->registerTopLevelTask(sr->registerServiceTask(new ProjectViewImpl()));
    ts->registerTopLevelTask(sr->registerServiceTask(new ScriptRegistryService()));
}

}//namespace

using namespace GB2;

static QString parseOptions(int argc, char **argv, QStringList* urls, QStringList* schemes, AppContextImpl* appContext) {
    QStringList options;
    //QStringList urls;
    QString scriptFile;
    for (int i = 0; i < argc; ++i) {
        QString str = QString::fromLocal8Bit(argv[i]);
        if (str.endsWith(".js",Qt::CaseInsensitive)){
            scriptFile=str;
        } else
            options << str;//BaseIOAdapters::str2url(str);
    }
    if(options.isEmpty())
        return scriptFile;
    //////////////////////////////////////////////////////////////////////////
    // Help for options. Option: --help.
    if(options.contains(QString("--help"))){
        printf("%s\n", AppContextImpl::tr("Console version of UGENE version %1.%2.%3").arg(UGENE_VERSION_1).arg(UGENE_VERSION_2).arg(UGENE_VERSION_3).toAscii().constData());
        printf("%s\n", AppContextImpl::tr("Usage: congene [options] [--suite <path-to-suite-or-list> [<path-to-suite-or-list2> ...]] [--scheme <path-to-workflow-scheme> [<path-to-workflow-scheme2> ...]]").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("Options:").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --help\t\t\t\tShow this help information").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --suite <suite-or-list>\t\tLoad and run test suites or list of tests").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --scheme <workflow-scheme>\tLoad and run workflow designer scheme").toAscii().constData());
        printf("\n");
        printf("%s\n", AppContextImpl::tr("  --test-timeout=<number>\t\tSet time out for tests").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --test-num-threads=<number>\t\tSet number of threads for tests").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --teamcity-out\t\t\tOutput test's messages for TeamCity system").toAscii().constData());
        printf("\n");
        printf("%s\n", AppContextImpl::tr("  --log-no-show-date\t\t\tDon`t show date&time info at log").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --log-no-show-level\t\t\tDon`t show message level at log").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --log-no-show-category\t\tDon`t show message category at log").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --log-level-none\t\t\tDon`t show log messages").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --log-level-error\t\t\tShow only error log messages").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --log-level-info\t\t\tShow error and info log messages(Default)").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --log-level-details\t\t\tShow details information messages").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --log-level-trace\t\t\tShow trace messages").toAscii().constData());
        printf("\n");
        printf("%s\n", AppContextImpl::tr("  --no-task-status-bar\t\t\tDon`t show task status bar").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --color-output\t\t\tColored output").toAscii().constData());
        printf("%s\n", AppContextImpl::tr("  --load-settings-file==<filename>\tLoad other settings file").toAscii().constData());
        exit(0);
    }
    //////////////////////////////////////////////////////////////////////////
    //Suite adding. Option -suite
    int timeOut=0, numThreads=0;
    bool useOtherSettingFile=false;
    for (int i=0;i<options.size();i++)
    {
        QString curOption=options.at(i);
        if(curOption.startsWith('-')){
            //printf("Option: %s\n", curOption.toAscii().constData());
            if(curOption.startsWith(QString("--suite"))){
                options.removeAt(i);
                if(i<options.size()){
                    curOption=options.at(i);
                    if(curOption.startsWith(QString("-"))){
                        fprintf(stderr,"%s\n", AppContextImpl::tr("Wrong using --suite option. Do not have selected suites.").toAscii().constData());
                    }else{
                        while(!curOption.startsWith(QString("-"))&&(i<options.size())){
                            *urls << curOption;
                            options.removeAt(options.indexOf(curOption));
                            //i++;
                            if(i<options.size()){
                                curOption=options.at(i);
                            }
                        }
                    }
                    i--;//???
                }else{
                    fprintf(stderr,"%s\n", AppContextImpl::tr("Wrong using --suite option. Do not have selected suites.").toAscii().constData());
                }
            }else if(curOption.startsWith(QString("--scheme"))){
                options.removeAt(i);
                if(i<options.size()){
                    curOption=options.at(i);
                    if(curOption.startsWith(QString("-"))){
                        fprintf(stderr,"%s\n", AppContextImpl::tr("Wrong using --scheme option. Do not have selected workflow scheme.").toAscii().constData());
                    }else{
                        while(!curOption.startsWith(QString("-"))&&(i<options.size())){
                            *schemes << curOption;
                            options.removeAt(i);
                            //i++;
                            if(i<options.size()){
                                curOption=options.at(i);
                            }
                        }
                    }
                    i--;//???
                }else{
                    fprintf(stderr,"%s\n", AppContextImpl::tr("Wrong using --scheme option. Do not have selected workflow scheme.").toAscii().constData());
                }
            }else if(curOption.startsWith(QString("--test-timeout="))){
                timeOut=curOption.split('=',QString::SkipEmptyParts).at(1).toInt();
                options.removeAt(i);
                if (timeOut<0)
                    timeOut=0;


            }else if(curOption.startsWith(QString("--test-num-threads="))){
                numThreads=curOption.split('=',QString::SkipEmptyParts).at(1).toInt();
                options.removeAt(i);
                if (numThreads<=0)
                    numThreads=5;
            }else
            //////////////////////////////////////////////////////////////////////////
            // Loading other settings file
            if(curOption.startsWith(QString("--load-settings-file="))){
                QString pathToSettings=curOption.split('=',QString::SkipEmptyParts).at(1);
                delete AppContext::getSettings();
                appContext->setSettings(NULL);
                SettingsImpl* settings = new SettingsImpl(pathToSettings);
                appContext->setSettings(settings);
                options.removeAt(i);
                useOtherSettingFile=true;
            }
        }
    }
    if(useOtherSettingFile){
        return scriptFile;
    }
    //////////////////////////////////////////////////////////////////////////
    // LogSettings. Options: --log-no-show-date, --log-no-show-level, --log-no-show-category
    // LogLevel_TRACE, LogLevel_DETAILS, LogLevel_INFO, LogLevel_ERROR
    if(options.contains(QString("--log-no-show-date"))){
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "showDate", false);
        options.removeAt(options.indexOf(QString("--log-no-show-date")));
    }else{
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "showDate", true);
    }
    if(options.contains(QString("--log-no-show-level"))){
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "showLevel", false);
        options.removeAt(options.indexOf (QString("--log-no-show-level")));
    }else{
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "showLevel", true);
    }
    if(options.contains(QString("--log-no-show-category"))){
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "showCategory", false);
        options.removeAt(options.indexOf(QString("--log-no-show-category")));
    }else{
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "showCategory", true);
    }
    // Options: --log-level-none, --log-level-error, --log-level-info, --log-level-details, --log-level-trace, 
    if(options.contains(QString("--log-level-none"))){
        options.removeAt(options.indexOf(QString("--log-level-none")));
        for(int i=0;i<LogLevel_NumLevels;i++)
            AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "activeFlagLevel"+QString::number(i), false);
    }else if(options.contains(QString("--log-level-error"))){
        options.removeAt(options.indexOf(QString("--log-level-error")));
        for(int i=0;i<LogLevel_NumLevels;i++)
            AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "activeFlagLevel"+QString::number(i), i >= LogLevel_ERROR);
    }else if(options.contains(QString("--log-level-info"))){
        options.removeAt(options.indexOf(QString("--log-level-info")));
        for(int i=0;i<LogLevel_NumLevels;i++)
            AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "activeFlagLevel"+QString::number(i), i >= LogLevel_INFO);
    }else if(options.contains(QString("--log-level-details"))){
        options.removeAt(options.indexOf(QString("--log-level-details")));
        for(int i=0;i<LogLevel_NumLevels;i++)
            AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "activeFlagLevel"+QString::number(i), i >= LogLevel_DETAILS);
    }else if(options.contains(QString("--log-level-trace"))){
        options.removeAt(options.indexOf(QString("--log-level-trace")));
        for(int i=0;i<LogLevel_NumLevels;i++)
            AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "activeFlagLevel"+QString::number(i), i >= LogLevel_TRACE);
    }else{
        for(int i=0;i<LogLevel_NumLevels;i++)
            AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "activeFlagLevel"+QString::number(i), i >= LogLevel_INFO);
    }

    //////////////////////////////////////////////////////////////////////////
    // Task Status Bar Settings
    if(options.contains(QString("--no-task-status-bar"))){
        options.removeAt(options.indexOf(QString("--no-task-status-bar")));
        AppContext::getSettings()->setValue(TSB_SETTINGS_ROOT + "showTaskStatusBar", false);
    }else{
        AppContext::getSettings()->setValue(TSB_SETTINGS_ROOT + "showTaskStatusBar", true);
    }
    //////////////////////////////////////////////////////////////////////////
    // Colored output enable
    if(options.contains(QString("--color-output"))){
        options.removeAt(options.indexOf(QString("--color-output")));
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "colorOut", true);
    }else{
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "colorOut", false);
    }
    //////////////////////////////////////////////////////////////////////////
    // TeamCity output enable
    if(options.contains(QString("--teamcity-out"))){
        options.removeAt(options.indexOf(QString("--teamcity-out")));
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "teamcityOut", true);
    }else{
        AppContext::getSettings()->setValue(LOG_SETTINGS_ROOT + "teamcityOut", false);
    }
    //////////////////////////////////////////////////////////////////////////
    // Setting timeout and number threads options
    AppContext::getSettings()->setValue(TR_SETTINGS_ROOT + TIME_OUT_VAR, QString::number(timeOut));
    AppContext::getSettings()->setValue(TR_SETTINGS_ROOT + NUM_THREADS_VAR, QString::number(numThreads));
    if(options.size()>0){
        for (int i=0;i<options.size();i++)
        {
            fprintf(stderr,"%s\n",AppContextImpl::tr("Unrecognized option: %1.").arg(options.at(i)).toAscii().constData());
        }
        fprintf(stderr,"%s\n",AppContextImpl::tr("Try 'congene --help' for more information").toAscii().constData());
        exit(1);
    }
    return scriptFile;
}
static void openDocs(QStringList* urls, QStringList* schemes) {

    if (urls->size()>0){
    TestStarter* ts=new TestStarter(*urls);
    
    GTestEnvironment* envs=ts->getEnv();
    envs->setVar(TIME_OUT_VAR, AppContext::getSettings()->getValue(TR_SETTINGS_ROOT + TIME_OUT_VAR,QString("0")).toString());
    envs->setVar(NUM_THREADS_VAR, AppContext::getSettings()->getValue(TR_SETTINGS_ROOT + NUM_THREADS_VAR,QString("5")).toString());

    QObject::connect(AppContext::getPluginSupport(), SIGNAL(si_allStartUpPluginsLoaded()), 
        new TaskStarter(ts), SLOT(registerTask()));
    }
    if(schemes->size()>0){
        // run workflow scheme
        QObject::connect(AppContext::getPluginSupport(), SIGNAL(si_allStartUpPluginsLoaded()), 
            new TaskStarter(new WorkflowStarter(*schemes)), SLOT(registerTask()));
    }
}


static void updateStaticTranslations() {
    GObjectTypes::initTypeTranslations();
}

static void setSearchPaths() {
    //set search paths for data files
    QStringList dataSearchPaths;
#if (defined(Q_OS_LINUX) || defined(Q_OS_UNIX)) && defined( UGENE_DATA_DIR )
    //using directory which is set during installation process on linux
    QString ugene_data_dir( UGENE_DATA_DIR );
    if( QDir(ugene_data_dir).exists() ) {
        dataSearchPaths.push_back( QString(UGENE_DATA_DIR) );
    }
#endif
    const static char * RELATIVE_DATA_DIR = "/data";
    const static char * RELATIVE_DEV_DATA_DIR = "/../../data";
    //on windows data is normally located in the application directory
    QString appDirPath = QCoreApplication::applicationDirPath();
    if( QDir(appDirPath+RELATIVE_DATA_DIR).exists() ) {
        dataSearchPaths.push_back( appDirPath+RELATIVE_DATA_DIR );
    } else if( QDir(appDirPath+RELATIVE_DEV_DATA_DIR).exists() ) {          //data location for developers
        dataSearchPaths.push_back( appDirPath+RELATIVE_DEV_DATA_DIR );
    }
    if( dataSearchPaths.empty() ) {
        dataSearchPaths.push_back("/");
    }
    QDir::setSearchPaths( PATH_PREFIX_DATA, dataSearchPaths );
    //now data files may be opened using QFile( "data:some_data_file" )
} 

int main(int argc, char **argv) 
{
    const char* build = QT_VERSION_STR, *runtime = qVersion();
    if (strcmp(build, runtime) > 0){
        printf("Installed Qt version must be %s or greater \r\n", QT_VERSION_STR);
        return -1;
    }

    if (argc == 1) {
        fprintf(stderr, "Console version of UGENE version %d.%d.%d\n"
            "congene: missing operands\n"
            "Try 'congene --help' for more information\n",
            UGENE_VERSION_1, UGENE_VERSION_2, UGENE_VERSION_3
            );
        return -1;   
    }

    GTIMER(c1, t1, "main()->QApp::exec");

    QCoreApplication app(argc, argv);
    QCoreApplication::addLibraryPath(QCoreApplication::applicationDirPath());
    QString devPluginsPath = QDir(QCoreApplication::applicationDirPath()+"/../../installer/windows").absolutePath();
    QCoreApplication::addLibraryPath(devPluginsPath); //dev version

    setSearchPaths();

    AppContextImpl* appContext = AppContextImpl::getApplicationContext();

    //1 create 
    SettingsImpl* globalSettings = new SettingsImpl(QSettings::SystemScope);
    appContext->setGlobalSettings(globalSettings);

	SettingsImpl* settings = new SettingsImpl(QSettings::UserScope);
	appContext->setSettings(settings);

    AppSettings* appSettings = new AppSettingsImpl();
    appContext->setAppSettings(appSettings);

    UserAppsSettings* userAppSettings = AppContext::getAppSettings()->getUserAppsSettings();

	QTranslator translator;
    QString transFile[] = {
        userAppSettings->getTranslationFile(),
        "transl_" + QLocale::system().name(),
        "transl_en"
    };
    bool trOK = false;
    for (int i = transFile[0].isEmpty() ? 1 : 0; i < 3; ++i) {
        if (!translator.load(transFile[i], QCoreApplication::applicationDirPath())) {
            fprintf(stderr, "Translation not found: %s\n", transFile[i].toAscii().constData());
        } else {
            trOK = true;
            break;
        }
    }
    if (!trOK) {
        fprintf(stderr, "No translations found, exiting\n");
	    return 1;   
	}
	
	app.installTranslator(&translator);
    updateStaticTranslations();
    
    AppContext::getSettings()->setValue(GLOBAL_SETTINGS + "drawIcons", false);

    QString startupScript;
    QStringList *urls=new QStringList();
    QStringList *schemes=new QStringList();
    if (argc > 1) {
        startupScript = parseOptions(argc - 1, argv + 1, urls, schemes, appContext);
    }
    /* this is dead code
    else {
        fprintf(stderr, "Console version of UGENE version %d.%d.%d\n"
            "congene: missisng operands\n",
            "Try 'congene --help' for more information\n",
            UGENE_VERSION_1, UGENE_VERSION_2, UGENE_VERSION_3
            );
        return -1;   
    }*/
    LogDriver logs;
    // QStringList envList = QProcess::systemEnvironment();
    // #ifdef _DEBUG
    //     logsCache.print_to_console = envList.indexOf("UGENE_PRINT_TO_CONSOLE=true") >= 0 || envList.indexOf("UGENE_PRINT_TO_CONSOLE=1") >= 0;
    // #endif
    logCat.details(AppContextImpl::tr("UGENE initialization started"));

    ResourceTracker* resTrack = new ResourceTracker();
    appContext->setResourceTracker(resTrack);

    TaskSchedulerImpl* ts = new TaskSchedulerImpl(appSettings->getAppResourcePool());
	appContext->setTaskScheduler(ts);

    AnnotationSettingsRegistry* asr = new AnnotationSettingsRegistry();
    appContext->setAnnotationSettingsRegistry(asr);

    TestFramework* tf = new TestFramework();
    appContext->setTestFramework(tf);

    GScriptModuleRegistry* smreg=new GScriptModuleRegistry();
    appContext->setScriptModuleRegistry(smreg);

//     MainWindowImpl* mw = new MainWindowImpl();
// 	appContext->setMainWindow(mw);
// 	mw->show();
// 
//     AppSettingsGUI* appSettingsGUI = new AppSettingsGUIImpl();
//     appContext->setAppSettingsGUI(appSettingsGUI);
// 
//     AppContext::getMainWindow()->getDockManager()->registerDock(MWDockArea_Bottom, new TaskViewDockWidget(), QKeySequence(Qt::ALT | Qt::Key_2));
//     AppContext::getMainWindow()->getDockManager()->registerDock(MWDockArea_Bottom, new LogViewDockWidget(&logsCache), QKeySequence(Qt::ALT | Qt::Key_3));
//     
//     GObjectViewFactoryRegistry* ovfr = new GObjectViewFactoryRegistry();
//     appContext->setObjectViewFactoryRegistry(ovfr);

    PluginSupportImpl* psp = new PluginSupportImpl();
    appContext->setPluginSupport(psp);

    ServiceRegistryImpl* sreg = new ServiceRegistryImpl() ;
    appContext->setServiceRegistry(sreg);

	DocumentFormatRegistryImpl* dfr = new DocumentFormatRegistryImpl();
	appContext->setDocumentFormatRegistry(dfr);

    DocumentFormatConfigurators* dfc = new DocumentFormatConfigurators();
    appContext->setDocumentFormatConfigurators(dfc);
    BaseDocumentFormatConfigurators::initBuiltInConfigurators();
    

	IOAdapterRegistryImpl* io = new IOAdapterRegistryImpl();
	appContext->setIOAdapterRegistry(io);

	DNATranslationRegistry* dtr = new DNATranslationRegistry();
	appContext->setDNATranslationRegistry(dtr);

	DNAAlphabetRegistry* dal = new DNAAlphabetRegistryImpl(dtr);
	appContext->setDNAAlphabetRegistry(dal);

	ProjectLoaderImpl* pli = new ProjectLoaderImpl();
	appContext->setProjectLoader(pli);

//     ScriptManagerView * smv = new ScriptManagerView();
// 
// 	DBXRefRegistry* dbxr = new DBXRefRegistry();
// 	appContext->setDBXRefRegistry(dbxr);
// 
//     MSAColorSchemeRegistry* mcsr = new MSAColorSchemeRegistry();
//     appContext->setMSAColorSchemeRegistry(mcsr);

	SubstMatrixRegistry* smr = new SubstMatrixRegistry();
	appContext->setSubstMatrixRegistry(smr);

	SmithWatermanTaskFactoryRegistry* swar = new SmithWatermanTaskFactoryRegistry();
	appContext->setSmithWatermanTaskFactoryRegistry(swar);

    MolecularSurfaceFactoryRegistry* msfr = new MolecularSurfaceFactoryRegistry();
    appContext->setMolecularSurfaceFactoryRegistry(msfr);

    SWResultFilterRegistry* swrfr = new SWResultFilterRegistry();
	appContext->setSWResultFilterRegistry(swrfr);

    SecStructPredcitAlgRegistry* sspar = new SecStructPredcitAlgRegistry();
    appContext->setSecStructPedictAlgRegistry(sspar);

    CudaGpuRegistry * cgr = new CudaGpuRegistry();
    appContext->setCudaGpuRegistry( cgr ); 

    Workflow::WorkflowEnv::init(new Workflow::WorkflowEnvImpl());
    Workflow::BioActorLibrary::init();
    
    
    if ((urls->size() > 0)||(schemes->size() > 0)){
        openDocs(urls, schemes);
    } else {
        //if not have --help option
        fprintf(stderr, "congene: no any tasks for evaluating\n");
        return -1;   
    }
    
    GScriptRunner* sr = new GScriptRunner(startupScript);
    appContext->setScriptRunner(sr);
    TaskStatusBarCon* tsbc=new TaskStatusBarCon();
    registerCoreServices();

    //2 run QT 
    t1.stop();
    logCat.info(AppContextImpl::tr("UGENE started"));
    ShutdownTask watchQuit(&app);
    int rc = app.exec();

    //3. deallocate resources
    Workflow::WorkflowEnv::shutdown();
    //delete smv;
   
    delete tsbc;

    delete swrfr;
	appContext->setSWResultFilterRegistry(NULL);

	delete swar;
	appContext->setSmithWatermanTaskFactoryRegistry(NULL);

    delete msfr;
    appContext->setMolecularSurfaceFactoryRegistry(NULL);

    delete sr;
	appContext->setScriptRunner(NULL);

	delete smr;
	appContext->setSubstMatrixRegistry(NULL);

//     delete mcsr;
//     appContext->setMSAColorSchemeRegistry(NULL);
// 
// 	delete dbxr;
//     appContext->setDBXRefRegistry(NULL);
// 
    delete pli;
	appContext->setProjectLoader(NULL);

    delete sreg;
    appContext->setServiceRegistry(NULL);

	delete psp;
    appContext->setPluginSupport(NULL);

// 	delete mw;
// 	appContext->setMainWindow(NULL);
// 
    delete tf;
    appContext->setTestFramework(0);
// 
// 	delete ovfr;
// 	appContext->setObjectViewFactoryRegistry(NULL);

	delete dal;
	appContext->setDNAAlphabetRegistry(NULL);

	delete dtr;
	appContext->setDNATranslationRegistry(NULL);

	delete io;
	appContext->setIOAdapterRegistry(NULL);

    delete dfc;
    appContext->setDocumentFormatConfigurators(NULL);

    delete dfr;
	appContext->setDocumentFormatRegistry(NULL);

	delete ts;
	appContext->setTaskScheduler(NULL);

	delete asr;
    appContext->setAnnotationSettingsRegistry(NULL);

    delete resTrack;
    appContext->setResourceTracker(NULL);

    delete cgr;
    appContext->setCudaGpuRegistry(NULL);

//     delete appSettingsGUI;
//     appContext->setAppSettingsGUI(NULL);

    delete appSettings;
    appContext->setAppSettings(NULL);

    delete settings;
    appContext->setSettings(NULL);

	delete globalSettings;
	appContext->setGlobalSettings(NULL);
	
    delete smreg;
    appContext->setScriptModuleRegistry(NULL);
    
    delete sspar;
    appContext->setSecStructPedictAlgRegistry(NULL);

	return rc;
}

