/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_COUNTER_H_
#define _GB2_COUNTER_H_

#include "core_api.h"

#include <QtCore/QList>

namespace GB2 {

class GB2_COREAPI_EXPORT GCounter : public QObject {
    Q_OBJECT
public:
    GCounter(const QString& name, const QString& suffix, double scale = 1);
    ~GCounter();

    static const QList<GCounter*>& allCounters() {return getCounters();}

    QString name;
    QString suffix;
    qint64  totalCount;
    double  counterScale;
    bool    dynamicCounter; //true if created and deleted dynamically at application runtime (not static init time)

    double scaledTotal() const {return totalCount / counterScale;}
    
protected:
    
    static QList<GCounter*>& getCounters();
};


class GB2_COREAPI_EXPORT SimpleEventCounter {
public:
    SimpleEventCounter(GCounter* tc) : totalCounter(tc), eventCount(0){ assert(tc!=NULL);}
    virtual ~SimpleEventCounter() {totalCounter->totalCount+=eventCount;}
    
    GCounter*   totalCounter;
    qint64      eventCount;
};

} //namespace

#endif
