/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_VECTOR_MATH_H_
#define _GB2_VECTOR_MATH_H_

#include <QtGlobal>
#include <math.h>
#include <core_api/core_api.h>

namespace GB2
{

class GB2_COREAPI_EXPORT Vector3D {
public:
	double x, y, z;

	explicit Vector3D(double xi = 0.0, double yi = 0.0, double zi = 0.0);
	Vector3D(const Vector3D& v);
	Vector3D& operator = (const Vector3D& v);
	bool operator == (const Vector3D& other);
	bool operator != (const Vector3D& other);
	double& operator [] (unsigned int i);
	double operator [] (unsigned int i) const;
	Vector3D& operator += (const Vector3D& v);
	Vector3D& operator -= (const Vector3D& v);
	Vector3D& operator *= (double f);
	Vector3D& operator /= (double f);
	void set(double xs, double ys, double zs);
	double length(void) const;
	double lengthSquared(void) const;
	void normalize(void);
};

GB2_COREAPI_EXPORT Vector3D operator - (const Vector3D& a);
GB2_COREAPI_EXPORT Vector3D operator + (const Vector3D& a, const Vector3D& b);
GB2_COREAPI_EXPORT Vector3D operator - (const Vector3D& a, const Vector3D& b);
GB2_COREAPI_EXPORT double vector_dot(const Vector3D& a, const Vector3D& b);
GB2_COREAPI_EXPORT Vector3D vector_cross(const Vector3D& a, const Vector3D& b);
GB2_COREAPI_EXPORT Vector3D operator * (const Vector3D& v, double f);
GB2_COREAPI_EXPORT Vector3D operator * (double f, const Vector3D& v);
GB2_COREAPI_EXPORT Vector3D operator / (const Vector3D& v, double f);




}//namespace

#endif //_GB2_VECTOR_MATH_H_
